<?php

namespace App\Api\Http\Requests\Task;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class TaskListRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(Request $request): array
    {
        return [
            'list' => 'required',
            'from_date' => ($request->list == 4) ? 'required' : '',
            'to_date' => ($request->list == 4) ? 'required' : '',
        ];
    }
}
