<?php

namespace App\Api\Http\Resources\Tasks;
use Illuminate\Http\Resources\Json\JsonResource;

class AnalyticsResource extends JsonResource
{
    public function toArray($request): array

    
    {
        if($this->create_task_id ==5){
            $remarks = $this->task_completion_remarks;
        }else{
            $remarks = $this->remarks;
        }
      
        return [
            'id' => $this->id,
            'lead_id' => $this->lead_id,
            'name' => (string)$this->getLead->enquirer_name,
            'email' =>(string) $this->getLead->email,
            'project_type_id'=>(string)$this->getLead->project_type,
            'task_sale_status'=>(string)$this->getLead->task_sale_status,
            'mobile' => (string)$this->getLead->mobile ,
            'schedule_date' => (string)$this->schedule_date,
            'schedule_time'  => (string)$this->schedule_time,
            'task_completed_status' => (string)$this->task_completed_status,
            'task_completion_remark' =>(string)$this->task_completion_remarks,
            'created_at' => (string)$this->created_at,
            'remarks' => (string) $remarks,
            'sales_person' => $this->getCreatedBy ? (string)$this->getCreatedBy->name : "",
            'getTaskType' => $this->create_task_id ? new TaskTypeResource($this->whenLoaded('getTaskType')) : "",
            'project' => $this->project ? new ProjectResource($this->whenLoaded('getProject')) : (object)[],
        ];
    }
}
