<?php

namespace App\Api\Http\Resources\PreferredProject;

use Illuminate\Http\Resources\Json\JsonResource;

class PreferredProjectResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            // 'project_name' => (string)$this->project_name,
            'project_name' => (string)$this->project_name,
            'project_type' => (string)$this->project_type,
            'project_code' => (string)$this->project_code,
            'proposal_type'=>(string)$this->proposal_type,
            'project_image' => $this->home_page_image ? asset('uploads/' . $this->home_page_image) : '',
        ];
    }
}
