<?php

namespace App\Api\Http\Resources\Project;

use App\Api\Http\Resources\ProjectType\ProjectTypeResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ProjectResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            // 'project_name' => (string)$this->project_name,
            'project_name' => mb_strtoupper((string)$this->project_name),
            'project_short' => (string)$this->project_code,
            'project_type' => new ProjectTypeResource($this->whenLoaded('getProjectType'))
        ];
    }
}
