<?php

namespace App\Api\Http\Resources\ProjectView;

use App\Api\Http\Resources\ProjectType\ProjectTypeResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ProjectViewResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'project_name' => (string)$this->project_name,
            'project_type' => (string)$this->project_type,
            'project_code' => (string)$this->project_code,
            'project_image' => $this->home_page_image ? asset('uploads/' . $this->home_page_image) : '',
            'location_map' => (string)$this->location_map,
            'location' => (string)$this->location,
            'project_description' => (string)$this->project_description,
            'ebrochure' =>  $this->ebrochure ? asset('uploads/' . $this->ebrochure) : '',
            'availability_chart' => $this->availability_chart ? asset('uploads/' . $this->availability_chart) : '',
            'mou' =>$this->mou ? asset('uploads/' . $this->mou) : '',
            'progress_report' => $this->progress_report ? asset('uploads/' . $this->progress_report) : '',
            'allotment_letter' => $this->allotment_letter ? asset('uploads/' . $this->allotment_letter) : '',
            'llp' => $this->llp ? asset('uploads/' . $this->llp) : '',
            'walk_through' => $this->video_link ??'',
            // 'deed' => $this->deed ? asset('uploads/' . $this->deed) : '',
            'leaflet'=>$this->term_sheet ? asset('uploads/' . $this->term_sheet) : '',
            'sale_agreement' => $this->sale_agreement ? asset('uploads/' . $this->sale_agreement) : '',
            'sample_calculation' => $this->sample_calculation ? asset('uploads/' . $this->sample_calculation) : '',
            'email_template' => $this->getProjectTemplate ? $this->getProjectTemplate->email_template : '',
            'email_template_non_html' => $this->getProjectTemplate ? strip_tags($this->getProjectTemplate->email_template) : '',
            'whatsapp_template' => $this->getProjectTemplate ? $this->getProjectTemplate->whatsapp_template : '',
            'whatsapp_template_non_html' => $this->getProjectTemplate ? strip_tags($this->getProjectTemplate->whatsapp_template) : '',
            'subject' => (string)$this->getProjectTemplate ? $this->getProjectTemplate->subject : '',
            
        ];
    }
}
