<?php

namespace App\Api\Http\Resources\Tasks;

use App\Api\Http\Resources\FollowupStatus\FollowupStatusResource;
use App\Api\Http\Resources\Project\ProjectResource;
use App\Api\Http\Resources\TaskType\TaskTypeResource;
use App\Api\Http\Resources\User\UserResource;
use App\Api\Http\Resources\Budget\BudgetResource;
use App\Api\Http\Resources\LeadCategory\LeadCategoryResource;
use App\Api\Http\Resources\LeadStage\LeadStageResource;
use App\Api\Http\Resources\PreferredProject\PreferredProjectResource;
use App\Api\Http\Resources\PriceList\PriceListResource;
use App\Api\Http\Resources\ProjectType\ProjectTypeResource;
use App\Api\Http\Resources\Sources\SourceResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class TaskResource extends JsonResource
{
    public function toArray($request): array

    
    {
        if($this->create_task_id ==5){
            $remarks = $this->task_completion_remarks;
        }else{
            $remarks = $this->remarks;
        }

        if($this->team_leader_approved == 1){
            $status = 'Approved';
        }elseif($this->team_leader_approved == 2){
            $status = 'Rejected';
        }

        $timestamp = $this->runo_created_at ?? '';
        $date = $timestamp ? Carbon::createFromTimestamp($timestamp) : null;
        $formattedDate = $date ? $date->format('Y-m-d') : '';
      
        return [
            'id' => $this->id,
            'lead_id' => $this->lead_id,
            'name' => (string)$this->getLead->enquirer_name,
            'email' =>(string) $this->getLead->email,
            'project_type_id'=>(string)$this->getLead->project_type,
            'task_sale_status'=>(string)$this->getLead->task_sale_status,
            'mobile' => (string)$this->getLead->mobile ,
            'schedule_date' => (string)$this->schedule_date,
            'schedule_time'  => (string)$this->schedule_time,
            'task_completed_status' => (string)$this->task_completed_status,
            'task_completion_remark' =>(string)$this->task_completion_remarks,
            'created_at' => (string)\Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at)
            ->format('Y-m-d h:i A'),
            'remarks' => (string) $remarks,
            'sales_person' => $this->getCreatedBy ? (string)$this->getCreatedBy->name : "",
            'getTaskType' => $this->create_task_id ? new TaskTypeResource($this->whenLoaded('getTaskType')) :  (object)[],
            'project' => $this->project ? new ProjectResource($this->whenLoaded('getProject')) : (object)[],
            'resident' => (string)($this->getLead ? $this->getLead->residential_status : ''),
            'location' => (string) ($this->getLead ? $this->getLead->location : ''),
            // 'followup_by' => new UserResource($this->whenLoaded('getFollowupBy')),
            'lead_status' => $this->lead_category ? new LeadCategoryResource($this->whenLoaded('getLeadCategory')) : (object)[],
            'lead_source' => $this->getLead->getSource->name ?? '',
            'place' => (string) ($this->getLead ? $this->getLead->place_address : ''),
            'duration' => $this->duration ?? '',
            'call_date' =>  $formattedDate,
            'create_task_id' => (string)$this->create_task_id ?? '',
            'latitude' => $this->getLead->latitude ?? '',
            'longitude' => $this->getLead->longitude ?? '',
            'team_leader_status' => $status ?? '',

            // 'lead_stage_id' => new LeadStageResource($this->whenLoaded('getLeadStage')),
            // 'followp_status' => new FollowupStatusResource($this->whenLoaded('getFollowupStatus')),
            // 'sitevisit_status' => new FollowupStatusResource($this->whenLoaded('getSiteVisitStatus')),
            // 'budget' => new BudgetResource($this->whenLoaded('getBudget')),
            // 'description' => (string)$this->description,

            // 'created_by' => new UserResource($this->whenLoaded('getCreatedBy')),
            // 'reminder' => (string)$this->reminder,
           

        ];
    }
}
