<?php

namespace App\Api\Http\Resources\User;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    public $collects = UserResource::class;
    public function toArray($request): array
    {
        
        return [
            'id' =>(string)$this->id ,
            'name' => (string)$this->name,
            'email' => (string)$this->email,
            'mobile' => (string)$this->mobile,
            'image' => $this->image ? asset('uploads/'.$this->image) : '',
           
        ];
    }
}
