<?php

use App\Api\Http\Controllers\Api\V1\Auth\LoginController;
use App\Api\Http\Controllers\Api\V1\Branch\BranchController;
use App\Api\Http\Controllers\Api\V1\Followup\FollowUpTypeController;
use App\Api\Http\Controllers\Api\V1\Lead\UnattendedLeadsController;
use App\Api\Http\Controllers\Api\V1\User\UserController;
use App\Api\Http\Controllers\Api\V1\Lead\LeadController;
use App\Api\Http\Controllers\Api\V1\Lead\WhatsappLeadStoreController;
use App\Api\Http\Controllers\Api\V1\Lead\LeadAllocationController;
use App\Api\Http\Controllers\Api\V1\Enquiry\EnquiryController;
use App\Api\Http\Controllers\Api\V1\Task\TaskController;
use App\Api\Http\Controllers\Api\V1\Task\TaskStatusController;
use App\Api\Http\Controllers\Api\V1\Event\EventCalenderController;
use App\Api\Http\Controllers\Api\V1\Home\HomeController;
use App\Api\Http\Controllers\Api\V1\Project\ProjectTypeController;
use App\Api\Http\Controllers\Api\V1\Project\PreferredProjectController;
use App\Api\Http\Controllers\Api\V1\Source\SourceController;
use App\Api\Http\Controllers\Api\V1\Budget\BudgetController;
use App\Api\Http\Controllers\Api\V1\Country\CountryController;
use App\Api\Http\Controllers\Api\V1\Customers\CustomerController;
use App\Api\Http\Controllers\Api\V1\DailyActivity\DailyActivityController;
use App\Api\Http\Controllers\Api\V1\DailyActivity\DailyCalculationController;
use App\Api\Http\Controllers\Api\V1\DailyActivity\DailyTaskActivityController;
use App\Api\Http\Controllers\Api\V1\DailyWorkPlan\DailyWorkPlanController;
use App\Api\Http\Controllers\Api\V1\LeadCategory\LeadCategoryController;
use App\Api\Http\Controllers\Api\V1\LeadStage\LeadStageController;
use App\Api\Http\Controllers\Api\V1\Followup\FollowupController;
use App\Api\Http\Controllers\Api\V1\Lead\CallLeadListController;
use App\Api\Http\Controllers\Api\V1\Lead\LeadDuplicateController;
use App\Api\Http\Controllers\Api\V1\Location\LocationController;
use App\Api\Http\Controllers\Api\V1\Notification\NotificationController;
use App\Api\Http\Controllers\Api\V1\Residence\ResidenceController;
use App\Api\Http\Controllers\Api\V1\Rono\RonoController;
use App\Api\Http\Controllers\Api\V1\TaskType\TaskTypeController;
use App\Api\Http\Controllers\Api\V1\UserCategory\UserCategoryController;
use App\Api\Http\Controllers\Api\V1\userLeadList\UserLeadListController;
use App\Api\Http\Controllers\Api\V2\Home\HomeNewController;
use App\Api\Http\Controllers\Api\V2\Home\SalesHeadController;
use App\Api\Http\Controllers\Api\V2\Home\TeamLeaderHomeController;
use App\Api\Http\Controllers\Api\V2\Leads\LeadsController;
use App\Api\Http\Controllers\Api\V2\Tasks\TasksController;
use App\Api\Http\Controllers\Api\V2\Analytics\AnalyticsController;
use App\Api\Http\Controllers\Api\V2\Analytics\QuarterAnalyticsController;
use App\Api\Http\Controllers\Api\V2\Analytics\UsersBasedQuarterAnalyticsController;
use App\Api\Http\Controllers\Api\V2\Contest\ContestFilterController;
use App\Api\Http\Controllers\Api\V2\CreateTask\CreateTaskController;
use App\Api\Http\Controllers\Api\V2\Incentive\IncentiveController;
use App\Api\Http\Controllers\Api\V2\DailySales\DailySalesReportController;
use App\Api\Http\Controllers\Api\V2\Leads\ReallocatedLeadController;
use App\Api\Http\Controllers\Api\V2\PerformanceTarget\PerformanceTargetsController;
use App\Api\Http\Controllers\Api\V2\Proposal\ProposalController;
use App\Api\Http\Controllers\Api\V2\Receipts\ReceiptsController;
use App\Api\Http\Controllers\Api\V2\Sale\SaleController;
use App\Api\Http\Controllers\Api\V2\salesHistory\SalesHistoryController;
use App\Api\Http\Controllers\Api\V2\SwitchCompany\SwitchCompanyController;
use App\Api\Http\Controllers\Api\V2\Users\TeamLeaderController;
use App\Api\Http\Controllers\Api\V2\Users\UsersController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('enquiry', [EnquiryController::class, 'store']);

Route::group(['prefix' => 'v1'], function () {
    Route::post('register', [LoginController::class, 'register']);
    Route::post('login', [LoginController::class, 'login']);
    Route::get('register-button-status', [LoginController::class, 'registerStatus']);
    Route::post('whatsapp-lead-store', [LeadController::class, 'WhatsappLeadStore']);
    Route::post('whatsapp-unattended-lead-store', [LeadController::class, 'WhatsappUnattendedLeadStore']);
    Route::post('kannur-promo-lead-store', [LeadController::class, 'kannurPromoLeadStore']);
    Route::post('aswin-oman-lead-store', [LeadController::class, 'aswinOmanLeadStore']);
    Route::post('najeeb-lead-store', [LeadController::class, 'najeebLeadStore']);
    Route::post('sahad-lead-store', [LeadController::class, 'sahadLeadStore']);
    Route::post('shahana-lead-store', [LeadController::class, 'ShahanaLeadStore']);
    Route::post('aswinu-lead-store', [LeadController::class, 'AswinULeadStore']);
    Route::post('salim-lead-store', [LeadController::class, 'SalimLeadStore']);
    Route::post('Jannathul-farhan-lead-store', [LeadController::class, 'JannathulFarhanLeadStore']);
    Route::post('faheem-lead-store', [LeadController::class, 'FaheemLeadStore']);
    Route::post('yusra-lead-store', [LeadController::class, 'yusraLeadStore']);
    Route::post('navas-lead-store', [LeadController::class, 'navasLeadStore']);
    Route::post('athul-aryan-lead-store', [LeadController::class, 'AthulAryanLeadStore']);
    Route::post('saira-banu-lead-store', [LeadController::class, 'sairaBanuLeadStore']);
    Route::post('shajahan-lead-store', [LeadController::class, 'ShajahanLeadStore']);
    Route::post('burayyan-lead-store', [LeadController::class, 'BurayyanLeadStore']);
    Route::post('naji-lead-store', [LeadController::class, 'NajiLeadStore']);
    Route::post('jasim-lead-store', [LeadController::class, 'JasimLeadStore']);
    Route::post('mahsoom-lead-store', [LeadController::class, 'MahsoomLeadStore']);
    Route::post('salva-lead-store', [LeadController::class, 'SalvaLeadStore']);
    Route::post('jufsad-lead-store', [LeadController::class, 'JufsadLeadStore']);
    Route::post('anuraj-lead-store', [LeadController::class, 'AnurajLeadStore']);
    Route::post('muhsina-lead-store', [LeadController::class, 'MuhsinaLeadStore']);
    Route::post('rushaid-lead-store', [LeadController::class, 'RushaidLeadStore']);
    Route::post('ajinas-lead-store', [LeadController::class, 'AjinasLeadStore']);
    Route::post('shareef-lead-store', [LeadController::class, 'ShareefLeadStore']);
    Route::post('hider-lead-store', [LeadController::class, 'HiderLeadStore']);
    Route::post('shantheep-lead-store', [LeadController::class, 'ShantheepLeadStore']);
    Route::post('siraj-lead-store', [LeadController::class, 'SirajLeadStore']);
    Route::post('sinan-lead-store', [LeadController::class, 'SinanLeadStore']);
    Route::post('mahir-lead-store', [LeadController::class, 'MahirLeadStore']);
    Route::post('moheenudheen-lead-store', [LeadController::class, 'MoheenudheenLeadStore']);
    Route::post('thejilsan-lead-store', [LeadController::class, 'ThejilsanLeadStore']);
    Route::post('fasal-rahman-lead-store', [LeadController::class, 'FasalRahmanLeadStore']);
    Route::post('sujin-lead-store', [WhatsappLeadStoreController::class, 'SujinLeadStore']);
    Route::post('ajinas-lead-store', [WhatsappLeadStoreController::class, 'AjinasLeadStore']);
    Route::post('nasla-lead-store', [WhatsappLeadStoreController::class, 'NaslaLeadStore']);
    Route::post('babeesh-lead-store', [WhatsappLeadStoreController::class, 'BabeeshLeadStore']);
    Route::post('shihabudheen-lead-store', [WhatsappLeadStoreController::class, 'ShihabudheenLeadStore']);
    Route::post('anjana-lead-store', [WhatsappLeadStoreController::class, 'AnjanaLeadStore']);
    Route::post('shabinas-lead-store', [WhatsappLeadStoreController::class, 'ShabinasLeadStore']);
    Route::post('afnas-lead-store', [WhatsappLeadStoreController::class, 'AfnasLeadStore']);
    Route::post('sunayana-lead-store', [WhatsappLeadStoreController::class, 'SunayanaLeadStore']);
    Route::post('ayisha-hiba-lead-store', [WhatsappLeadStoreController::class, 'AyishaHibaLeadStore']);
    Route::post('nijin-lead-store', [WhatsappLeadStoreController::class, 'NijinLeadStore']);
    Route::post('ajmal-lead-store', [WhatsappLeadStoreController::class, 'AjmalLeadStore']);
    Route::post('thaha-lead-store', [WhatsappLeadStoreController::class, 'ThahaLeadStore']);
    Route::post('sidharth-lead-store', [WhatsappLeadStoreController::class, 'SidharthLeadStore']);
    Route::post('aswin-lead-store', [WhatsappLeadStoreController::class, 'AswinLeadStore']);
    Route::post('razaque-lead-store', [WhatsappLeadStoreController::class, 'RazaqueLeadStore']);
    Route::post('afthab-lead-store', [WhatsappLeadStoreController::class, 'AfthabLeadStore']);
    Route::post('ravi-kiran-lead-store', [WhatsappLeadStoreController::class, 'RaviKiranLeadStore']);
    Route::post('muhammed-lal-lead-store', [WhatsappLeadStoreController::class, 'MuhammedLalLeadStore']);
    Route::post('akheel-lead-store', [WhatsappLeadStoreController::class, 'AkheelLeadStore']);
    Route::post('abhirami-lead-store', [WhatsappLeadStoreController::class, 'AbhiramiLeadStore']);
    Route::post('barjas-lead-store', [WhatsappLeadStoreController::class, 'BarjasLeadStore']);
    Route::post('neethu-lead-store', [WhatsappLeadStoreController::class, 'NeethuLeadStore']);
    Route::post('ajith-lead-store', [WhatsappLeadStoreController::class, 'AjithLeadStore']);
    Route::post('nishad-lead-store', [WhatsappLeadStoreController::class, 'NishadLeadStore']);
    Route::post('jasir-lead-store', [WhatsappLeadStoreController::class, 'JasirLeadStore']);
    Route::post('promo-lead-store', [LeadController::class, 'PromoLeadStore']);
    Route::post('runo', [RonoController::class, 'store']);
    Route::post('runo-interaction', [RonoController::class, 'storeInteraction']);

    Route::post('login-without-password', [LoginController::class, 'loginWithoutPassword']);

    Route::group(['middleware' => 'auth:sanctum'], function () {
        Route::get('users/profile', [UserController::class, 'index']);
        Route::get('user/delete-account', [UserController::class, 'DeleteAccount']);

        Route::post('logout', [LoginController::class, 'logout']);
        Route::post('change-password', [LoginController::class, 'changePassword']);

        Route::get('leads/unattended', [UnattendedLeadsController::class, 'index'])->name('leads.unattended');
        Route::get('leads/reallocated', [ReallocatedLeadController::class, 'index']);
        Route::put('leads/{lead}/unattended', [UnattendedLeadsController::class, 'update']);
        Route::get('leads/allocation-list', [LeadAllocationController::class, 'allocationlist']);
        Route::post('leads/sales-person-allocation', [LeadAllocationController::class, 'leadAllocation']);
        Route::resource('leads', LeadController::class)->only('index', 'store', 'update', 'show');

        Route::resource('tasks', TaskController::class)->only('index', 'store', 'show', 'destroy');
        Route::post('tasks/task-status/{task}', [TaskStatusController::class, 'status']);
        Route::post('tasks/task-new-status/{task}', [TaskStatusController::class, 'statusChange']);
        Route::post('tasks/make-new-appointment/{task}', [TaskStatusController::class, 'MakeNewAppointment']);
        Route::post('tasks/notintrested-task/{task}', [TaskStatusController::class, 'InvalidTask']);
        Route::post('daily-task-store', [DailyActivityController::class, 'store']);
        Route::get('daily-task-report', [DailyActivityController::class, 'Report']);
        Route::post('daily-task-store-unattended', [DailyActivityController::class, 'storeUnattended']);
        Route::get('daily-task-users-List', [DailyActivityController::class, 'usersList']);

        Route::post('event-calender', [EventCalenderController::class, 'eventCalender']);

        Route::get('project-type', [ProjectTypeController::class, 'index']);
        Route::post('preferred-project', [PreferredProjectController::class, 'preferredProject']);
        Route::post('executive-preferred-project', [PreferredProjectController::class, 'ExecutivePreferredProject']);
        Route::get('source', [SourceController::class, 'index']);
        Route::get('budget', [BudgetController::class, 'index']);
        Route::get('lead-category', [LeadCategoryController::class, 'index']);
        Route::get('lead-stage', [LeadStageController::class, 'index']);
        Route::get('followup-types', [FollowUpTypeController::class, 'index']);

        Route::get('followup-by', [FollowupController::class, 'index']);

        Route::get('task-type', [TaskTypeController::class, 'tasks']);
        Route::get('action-task-type', [TaskTypeController::class, 'Actiontasks']);
        Route::get('unnattended-action-task-type', [TaskTypeController::class, 'UnnAttendedtasks']);
        Route::get('daily-activity-task-type', [DailyActivityController::class, 'DailyActivitylist']);
        Route::get('residences', [ResidenceController::class, 'index']);

        Route::post('home', [HomeController::class, 'index']);
        Route::get('search/leads', [LeadController::class, 'search']);
        Route::get('search/tasks', [TaskController::class, 'search']);
        Route::get('customer/list', [CustomerController::class, 'index']);
        Route::get('locations', [LocationController::class, 'index']);
        Route::get('user-allocation', [LeadAllocationController::class, 'allocationUser']);
        Route::post('lead-duplicate-mobile', [LeadDuplicateController::class, 'leadMobileDuplicate']);
        Route::post('lead-duplicate-email', [LeadDuplicateController::class, 'leadEm ailDuplicate']);
        Route::get('notifications', [NotificationController::class, 'notifications']);
        Route::post('notifications', [NotificationController::class, 'updateNotification']);
        Route::get('branches', [BranchController::class, 'index']);
        Route::get('sales-head-branches', [BranchController::class, 'salesHeadBranch']);
        Route::get('get-projects', [PreferredProjectController::class, 'getProjects']);
        Route::get('preffered_project/{id}', [PreferredProjectController::class, 'view']);
        Route::get('get-countries', [CountryController::class, 'index']);
        Route::post('get-teamLeader-by-user', [UserCategoryController::class, 'getTeamLeaderByUser']);
        Route::get('get-users-lead-list', [UserLeadListController::class, 'list']);
        Route::get('daily-task-activity-list', [DailyTaskActivityController::class, 'index']);
        Route::post('daily-task-activity-approve', [DailyTaskActivityController::class, 'approve']);
        Route::post('daily-task-activity-reject', [DailyTaskActivityController::class, 'reject']);
        Route::post('daily-task-activity-delete/{task}', [DailyTaskActivityController::class, 'delete']);
        Route::post('daily-work-plan-store', [DailyWorkPlanController::class, 'store']);
        Route::get('daily-task-activity-calculation', [DailyCalculationController::class, 'index']);
        Route::post('new-user-home', [HomeNewController::class, 'index']);
        Route::post('lead-list', [LeadsController::class, 'index']);
        Route::post('task-list', [TasksController::class, 'index']);
        Route::post('users-task-list', [TasksController::class, 'usersTask']);
        Route::post('new-lead-list', [TasksController::class, 'listNewLead']);
        Route::post('rank-list', [HomeNewController::class, 'rankList']);
        Route::post('team-leader-home', [TeamLeaderHomeController::class, 'index']);
        Route::get('team-leader-tasks', [TeamLeaderHomeController::class, 'tasks']);
        Route::get('team-leader-todays-tasks', [TeamLeaderHomeController::class, 'todaysTasksList']);
        Route::post('branch-team-leaders', [TeamLeaderHomeController::class, 'getBranchTeamLeaders']);
        Route::post('sales-head-work-plan', [SalesHeadController::class, 'WorkPlans']);
        Route::post('sales-head-last-sales', [SalesHeadController::class, 'lastSaleDate']);
        Route::post('sales-head-home', [SalesHeadController::class, 'index']);
        Route::post('analytics', [AnalyticsController::class, 'index']);
        Route::post('quarters', [QuarterAnalyticsController::class, 'index']);
        Route::post('performance_targets', [PerformanceTargetsController::class, 'index']);
        Route::post('work-effeciancy-home', [HomeNewController::class, 'workEffeciencyChart']);
        Route::post('all-users-get', [UsersController::class, 'UsersAllList']);
        Route::get('branch-head-list', [UsersController::class, 'branchHeadsList']);
        Route::post('team-leaders-get', [UsersController::class, 'getBranchTeamLeaders']);
        Route::post('incentive-calculation', [IncentiveController::class, 'calculateIncentive']);
        Route::post('daily-sales-reports', [DailySalesReportController::class, 'index']);
        Route::post('switch-company', [SwitchCompanyController::class, 'switchCompany']);
        Route::post('users-based-quarters', [UsersBasedQuarterAnalyticsController::class, 'index']);
        Route::get('sale-history-customers', [SalesHistoryController::class, 'index']);
        Route::post('lead-task-details', [TasksController::class, 'leadTaskDetails']);
        Route::post('new-lead-task-details', [TasksController::class, 'newLeadTaskDetails']);
        Route::post('team-leader-efficiency', [TeamLeaderController::class, 'TeamLeaderEfficiency']);
        Route::post('source-efficiency', [TeamLeaderController::class, 'sourceEfficiency']);
        Route::get('contest-filter', [ContestFilterController::class, 'contest']);
        Route::get('get-create-tasks', [CreateTaskController::class, 'index']);
        Route::post('reallocated-lead-store', [ReallocatedLeadController::class, 'store']);
        Route::post('add-call-lead-list', [CallLeadListController::class, 'store']);
        Route::get('call-lead-list', [CallLeadListController::class, 'index']);
        Route::post('call-lead-add-task', [CallLeadListController::class, 'storeTasks']);
        Route::post('receipts', [ReceiptsController::class, 'store']);
        Route::get('bank', [ReceiptsController::class, 'bank']);
        Route::post('units', [ReceiptsController::class, 'units']);
        Route::post('customers', [ReceiptsController::class, 'customers']);
        Route::post('sale-data', [ReceiptsController::class, 'saleData']);
        Route::post('proposal-create', [ProposalController::class, 'create']);
        Route::post('store-retail-sale', [SaleController::class, 'storeRetailsale']);
        Route::post('sale-verify', [SaleController::class, 'storeSaleVerify']);
        Route::post('retail-sale-proposal', [SaleController::class, 'RetailSale']);
        Route::post('commercial-available-units', [ReceiptsController::class, 'commercialAvailableUnits']);
    });
});
