<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Branch extends Model
{
    use SoftDeletes;
    protected $table = 'branches';
    protected $primaryKey = 'id';
    protected $guarded = [];

    public function getPerformanceTarget()
    {
        return $this->hasOne(PerformanceTarget::class, 'branch_id', 'id');
    }

    public function getDsrBookings()
    {
        return $this->hasMany('\App\DsrBooking', 'branch_id', 'id');
    }
}
