<?php

namespace App\CallTracker\Http\Controllers\Api\V1\CallLog;

use App\Api\Http\Requests\Lead\UnattendedLeadRequest;
use App\CallLog;
use App\CallTracker\Http\Requests\CallLog\CallLogRequest;
use App\CallTracker\Http\Resources\CallLog\CallLogCollection as CallLogCallLogCollection;
use App\Http\Controllers\Controller;
use App\Lead;
use App\LeadBank;
use App\Location;
use App\SalesActivity;
use App\Task;
use App\User;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CallLogController extends Controller
{
    public function index(Request $request)
    {
        $lists = $request->list ?? 1;
        $from_date = $request->from_date;
        $to_date = $request->to_date;
        $week = Carbon::today()->subDays(15);
        $seven = Carbon::today()->subDays(7);
        $month = Carbon::now()->subMonth();
        $yesterday = Carbon::yesterday()->toDateString();

        $callLogs = CallLog::where('user_id', auth()->user()->id)
        ->when($request->type, function ($q) use ($request) {
            $q->where('call_type', $request->type);
        })
        ->when($lists == 1, function ($query) {
            $query->whereDate('call_created_at', today());
        })
        ->when($lists == 2, function ($query) use ($yesterday) {
            $query->whereDate('call_created_at', '=', $yesterday);
        })
        ->when($lists == 3, function ($query) use ($seven) {
            $query->whereDate('call_created_at', '>=', $seven);
        })
        ->when($lists == 4, function ($query) use ($week) {
            $query->whereDate('call_created_at', '>=', $week);
        })
        ->when($lists == 5, function ($query) use ($month) {
            $query->whereDate('call_created_at', '>=', $month);
        })
        ->when($lists == 6, function ($query) use ($request) {
            $from = $request->from_date;
            $to = $request->to_date;
            $query->whereBetween('call_created_at', [$from, $to]);
        })
        ->orderBy('created_at', 'desc')

        ->get();

        return $this->success(
            'Call Log!',
            new CallLogCallLogCollection($callLogs)
        );
    }

    public function store(CallLogRequest $request)
    {
        if ($request->phone) {
            $user = User::where('id', $request->user_id)->first();
            $callId = $user->id.'_'.Str::slug($request->type).'_'.now()->timestamp;

            if ($user->hasRole('team-leader') || $user->hasRole('executive') || $user->hasRole('sales-head')) {
                $phone_code = $request->phone_code;
                if ($phone_code == '+91') {
                    $taskcreateId = 17;
                } else {
                    $taskcreateId = 18;
                }

                $phoneNumber = $request->phone;

                $lead = Lead::whereRaw('SUBSTRING(mobile, -10) = ?', substr($phoneNumber, -10))
                    ->where(function ($query) use ($user) {
                        $query->where('created_by', $user->id)
                            ->orWhere('attended_by', $user->id);
                    })
                    ->first();
                $new = 'no';
                if (!$lead) {
                    $lead = new Lead();
                    $lead->enquirer_name = $request->name;
                    $lead->mobile = $request->phone;
                    $lead->phone_code = $request->phone_code;
                    $lead->source = 77;
                    $lead->lead_date = date('Y-m-d');
                    $lead->attended_by = $user->id;
                    $lead->created_by = $user->id;
                    $lead->updated_by = $user->id;
                    $lead->is_attended = 1;
                    $lead->runo = 1; //runo default value 0
                    $check = false;
                    $check_mobile_task = false;
                    $fifteenDays = now()->subDays(15);
                    $threeMonthBefore = now()->subMonths(3);
                    $mobile = $request->phone;

                    if (!empty($mobile)) {
                        $check = Lead::where('mobile', $mobile)
                            ->where(function ($query) use ($user) {
                                $query->where('created_by', $user->id)
                                    ->orWhere('attended_by', $user->id);
                            })->get()->last();

                        if (!$check) {
                            $mbb = $mobile;
                            $check = Lead::where('mobile', $mbb)
                                ->where(function ($query) use ($user) {
                                    $query->where('created_by', $user->id)
                                        ->orWhere('attended_by', $user->id);
                                })->get()->last();
                            if (!$check) {
                                $check = Lead::where('mobile', $mobile)
                                    ->where(function ($query) use ($user) {
                                        $query->where('created_by', $user->id)
                                            ->orWhere('attended_by', $user->id);
                                    })->get()->last();

                                if (!$check) {
                                    $n = 10;

                                    if (strlen($mobile) == 9) {
                                        $n = 9;
                                    }

                                    if (strlen($mobile) == 8) {
                                        $n = 8;
                                    }

                                    $start = strlen($mobile) - $n;
                                    $last_str = substr($mobile, $start);
                                    if ($start >= 0) {
                                        $check = Lead::where('mobile', 'LIKE', '%'.$last_str.'%')
                                            ->where(function ($query) use ($user) {
                                                $query->where('created_by', $user->id)
                                                    ->orWhere('attended_by', $user->id);
                                            })->get()->last();
                                    }
                                }
                            }
                        }
                    }

                    if ($check) {
                        $check_mobile_task = Task::where('lead_id', $check->id)
                            ->where(function ($query) use ($user) {
                                $query->where('created_by', $user->id);
                            })->get()->last();
                    }

                    if ($check && $check->created_at >= $threeMonthBefore) {
                        $lead->duplicate_entry = 'yes';
                        $lead->sales_head_approval = 0;
                    } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {
                        $lead->duplicate_entry = 'yes';
                        $lead->sales_head_approval = 0;
                    }
                    $lead->save();
                    $leadId = $lead->id;
                } else {
                    $leadId = $lead->id;
                }

                $taskCount = Task::where('lead_id', $leadId)->whereIn('create_task_id', [15, 17, 16, 18])->count();
                if ($taskCount == 0) {
                    $new = 'yes';
                }
                if ($request->duration > 30 && $new == 'yes') {
                    $taskData = [
                        'lead_id' => $leadId,
                        'create_task_id' => $taskcreateId,
                        'schedule_date' => date('Y-m-d'),
                        'created_by' => $user->id,
                        'task_completed_status' => 1,
                        'followup_by' => $user->id,
                        'runo_start_time' => $request->start_time ? $request->start_time : null,
                        'duration' => $request->duration ? $request->duration : null,
                        'runo_type' => $request->type ? $request->type : null,
                        'runo_status' => $request->status ? $request->status : null,
                        'tag' => $request->tag ? $request->tag : null,
                        'runo_created_at' => now(),
                        'runo_call_id' => $callId ?? '',
                    ];

                    $task = Task::create($taskData);
                } elseif ($request->duration > 120 && $new == 'no') {
                    $taskData = [
                        'lead_id' => $leadId,
                        'create_task_id' => 19,
                        'schedule_date' => date('Y-m-d'),
                        'created_by' => $user->id,
                        'task_completed_status' => 1,
                        'followup_by' => $user->id,
                        'runo_start_time' => $request->startTime ? $request->startTime : null,
                        'duration' => $request->duration ? $request->duration : null,
                        'runo_type' => $request->type ? $request->type : null,
                        'runo_status' => $request->status ? $request->status : null,
                        'tag' => $request->tag ? $request->tag : null,
                        'runo_created_at' => now(),
                        'runo_call_id' => $callId ?? '',
                    ];
                    $task = Task::create($taskData);
                } else {
                    $taskData = [
                        'lead_id' => $leadId,
                        'create_task_id' => 20, //runo interaction task id
                        'schedule_date' => date('Y-m-d'),
                        'created_by' => $user->id,
                        'task_completed_status' => 1,
                        'followup_by' => $user->id,
                        'runo_start_time' => $request->start_time ? $request->start_time : null,
                        'duration' => $request->duration ? $request->duration : null,
                        'runo_type' => $request->type ? $request->type : null,
                        'runo_status' => $request->status ? $request->status : null,
                        'tag' => $request->tag ? $request->tag : null,
                        'runo_created_at' => now(),
                        'runo_call_id' => $callId ?? '',
                    ];

                    $task = Task::create($taskData);
                }
                $type = 'users';
            } else {
                $type = 'cr';
                $phoneNumber = $request->phone;

                $lead = Lead::whereRaw('SUBSTRING(mobile, -10) = ?', substr($phoneNumber, -10))->where('sale_status', 'yes')->first();
                if ($lead) {
                    $sale = SalesActivity::where('lead_id', $lead->id)->first();

                    $sale_id = $sale->id;
                    $leadId = $sale->lead_id;
                }
            }

            $callLog = new CallLog();
            $callLog->lead_id = $leadId ?? null;
            $callLog->user_id = $user->id;
            $callLog->sale_id = $sale_id ?? null;
            $callLog->call_type = $request->type ? $request->type : null;
            $callLog->call_status = $request->status ? $request->status : null;
            $callLog->call_tag = $request->tag ? $request->tag : null;
            $callLog->call_start_time = $request->start_time ? $request->start_time : null;
            $callLog->call_end_time = $request->end_time ? $request->end_time : null;
            $callLog->call_duration = $request->duration ? $request->duration : null;
            $callLog->call_created_at = now();
            $callLog->call_id = $callId ?? '';
            $callLog->type = $type;
            $callLog->team_leader_id = $user->reporting_to;
            $callLog->branch_id = $user->branch_id;
            $callLog->app_type = 'Clique';
            $callLog->phone = $phoneNumber;
            $callLog->phone_code = $request->phone_code;
            $callLog->save();

            $check = false;
            $mobile = $request->phone;
            if (!$check) {
                $leadBankExists = LeadBank::where('mobile', $mobile)->exists();

                if (!$leadBankExists) {
                    $Lead_bank = new LeadBank();
                    $Lead_bank->lead_id = $lead->id;
                    $Lead_bank->enquirer_name = $request->name;
                    $Lead_bank->mobile = $request->phone;
                    $Lead_bank->source = 77;
                    $Lead_bank->lead_date = date('Y-m-d');
                    $Lead_bank->created_by = $user->id;
                    $Lead_bank->updated_by = $user->id;
                    $Lead_bank->attended_by = $user->id;

                    if (
                        $user->hasRole('super-admin') ||
                        $user->hasRole('admin')
                    ) {
                        $Lead_bank->attended_by = null;
                        if (!empty($attendedBy)) {
                            $Lead_bank->attended_by = $attendedBy;
                        }
                    } elseif (empty($user->reporting_to)) {
                        $Lead_bank->attended_by = null;
                    }
                    $Lead_bank->save();
                }
            }

            return response()->json([
                'status' => 'true',
                'message' => 'Interaction Lead Added Successfully',
                'data' => [
                    'lead_id' => $lead->id,
                    'name' => $lead->enquirer_name ?? '',
                    'phone' => $lead->phone ?? '',
                    'phone_code' => $lead->phone_code ?? '',
                    'project' => $lead->getPreferredProject ? $lead->getPreferredProject->project_name : '',
                    'source' => $lead->getSource ? $lead->getSource->name : '', ],
            ]);
        }

        return response()->json([
            'status' => 'false',
            'message' => 'Interaction Lead Failed',
            'data' => [
            ],
        ]);
    }

    public function storeInteraction(UnattendedLeadRequest $request)
    {
        $lead = Lead::find($request->lead_id);
        if ($request->location_id != 15 && $request->location_id != 16 && $request->location_id != '') {
            $locat = Location::find($request->location_id);
            $location = $locat->name;
        } else {
            $location = $request->location_name;
        }
        if ($request->create_task_id == 2 || $request->create_task_id == 3) {
            $category = 1;
        } elseif ($request->create_task_id == 4) {
            $category = 3;
        } elseif ($request->create_task_id != '') {
            $category = 4;
        } else {
            $category = null;
        }
        if ($lead) {
            DB::beginTransaction();

            try {
                $lead->lead_category = $category;
                $lead->enquirer_name = $request->name;
                $lead->lead_stage_id = $request->lead_stage_id;
                $lead->comment = $request->comment;
                $lead->is_attended = 1;
                $lead->location_id = $request->location_id ?? '';
                $lead->location = $location ?? '';
                $lead->budget = $request->budget;
                $lead->project_type = $request->project_type;
                $lead->preferred_project = $request->preferred_project;
                $lead->profession = $request->profession;
                $lead->investment_purpose = $request->investment_purpose;
                $lead->preferred_investment_location = $location;
                $lead->residential_status = $request->residential_status;
                $lead->job = $request->job;
                $lead->save();

                if ($request->create_task_id != 17) {
                    $task = new Task();
                    $task->lead_id = $lead->id;
                    $task->create_task_id = $request->create_task_id;
                    $task->followup_by = auth()->user()->id;
                    $task->lead_category = $category;
                    $task->schedule_date = $request->reminder ? date('Y-m-d', strtotime($request->reminder)) : '';
                    $task->reminder = $request->reminder ? date('Y-m-d', strtotime($request->reminder)) : '';
                    $task->created_by = auth()->user()->id;
                    $task->remarks = $request->comment;
                    $task->lead_stage = $request->lead_stage_id;

                    $task->save();
                }

                DB::commit();

                return $this->success('Status Updated');
            } catch (\Throwable $th) {
                info($th);
                DB::rollBack();

                return $this->error('Something went wrong! Please try again', 400);
            }
        }
    }

    public function callType(Request $request)
    {
        $lists = $request->list ?? 1;
        $week = Carbon::today()->subDays(15);
        $seven = Carbon::today()->subDays(7);
        $month = Carbon::now()->subMonth();
        $yesterday = Carbon::yesterday()->toDateString();

        $callLogs = CallLog::where('user_id', auth()->user()->id)
        ->when($lists == 1, function ($query) {
            $query->whereDate('call_created_at', today());
        })
        ->when($lists == 2, function ($query) use ($yesterday) {
            $query->whereDate('call_created_at', '=', $yesterday);
        })
        ->when($lists == 3, function ($query) use ($seven) {
            $query->whereDate('call_created_at', '>=', $seven);
        })
        ->when($lists == 4, function ($query) use ($week) {
            $query->whereDate('call_created_at', '>=', $week);
        })
        ->when($lists == 5, function ($query) use ($month) {
            $query->whereDate('call_created_at', '>=', $month);
        })
        ->when($lists == 6, function ($query) use ($request) {
            $from = $request->from_date;
            $to = $request->to_date;
            $query->whereBetween('call_created_at', [$from, $to]);
        })
        ->get();

        $missedCount = 0;
        $outgoingCount = 0;
        $incomingCount = 0;

        foreach ($callLogs as $callLog) {
            switch ($callLog->call_type) {
            case 'missed':
                $missedCount++;
                break;
            case 'outgoing':
                $outgoingCount++;
                break;
            case 'incoming':
                $incomingCount++;
                break;
        }
        }

        return response()->json([
            'status' => 'true',
            'message' => 'Call Log Count',
            'data' => [
                'missed' => strval($missedCount),
                'outgoing' => strval($outgoingCount),
                'incoming' => strval($incomingCount),
               ],
        ]);
    }
}
