<?php

namespace App\CallTracker\Http\Resources\CallLog;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class CallLogResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'lead_id' => (string) $this->lead_id,
            'type' => (string) $this->call_type,
            'duration' => (string) $this->call_duration,
            'name' => (string) $this->getLeads->enquirer_name,
            'user_name' => (string) $this->getUsers->name,
            'phone' => (string) $this->phone,
            'phone_code' => (string) $this->phone_code,
            'date' => Carbon::parse($this->call_created_at)->format('Y-m-d'),
            'start_time' => Carbon::parse($this->call_start_time)->format('h:i:s A'),
        ];
    }
}
