<?php

namespace App\CallTracker\Providers;

use App\Providers\ModuleServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class CallTrackerServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * This is used by Laravel authentication to redirect users after login.
     *
     * @var string
     */
    const HOME = 'api.home';

    /**
     * This namespace is applied to your controller Routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'App\CallTracker\Http\Controllers';

    /**
     *
     * @var string
     */
    protected $name = 'call-tracker';

    /**
     *
     * @var string
     */
    protected $path =  __DIR__ . '/../';

    /**
     *
     * @var bool
     */
    protected $useRootDomain = false;

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        parent::register();
    }

    /**
     * Define the "web" Routes for the application.
     *
     * These Routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {
        Route::middleware('web')
            //            ->namespace($this->namespace)
            ->group($this->getModulePath() . '/Routes/web.php');
    }

    /**
     * Define the "api" Routes for the application.
     *
     * These Routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {
        Route::middleware('api')
            // ->prefix('api')
            //            ->namespace($this->namespace)
            ->group($this->getModulePath() . '/Routes/api.php');
    }
}
