<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model
{
    use SoftDeletes;

    protected $table = 'companies';
    protected $primaryKey = 'id';
    public $timestamps = false;
    protected $guarded = [];

    public function getParent()
    {
        return $this->belongsTo(Company::class, 'parent_company_id', 'id');
    }

}
