<?php

namespace App\Console\Commands;

use App\Actions\Receipts\RawData\CreateReceiptFromRawData as RawDataCreateReceiptFromRawData;
use App\Actions\Receipts\RawData\CreateReceiptFromRawDataAction;
use App\InvoiceToCreateRawData;
use App\Lead;
use App\Receipt;
use App\SalesActivity;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class CreateReceiptFromRawData extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'create:receipt-from-raw-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create Receipts and Approve Receipts from Raw Data (client provided).';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        DB::beginTransaction();
        try {

            $receiptsToCreate = InvoiceToCreateRawData::where('is_created', 0)->get();

            foreach ($receiptsToCreate as $receiptData) {
                $saleActivity = SalesActivity::find($receiptData->sale_id);
                $client = Lead::find($receiptData->client_id);

                //creating-new-receipt
                $receipt = new Receipt();
                $receipt->client_id = $client->id;
                $receipt->project_id = $saleActivity->project;
                $receipt->unit_id = $saleActivity->project_unit ? $saleActivity->project_unit : '';
                $receipt->user_id = $receiptData->user_id;
                $receipt->sale_id = $receiptData->sale_id;
                $receipt->currency = 'INR';
                $receipt->receipt_date = $receiptData->date;
                $receipt->amount = $receiptData->amount;
                $receipt->remarks = $receiptData->voucher_type;

                //receipt-approve
                $receipt->is_approved = 1;
                $receipt->clearing_date = $receiptData->date;
                $receipt->receipt_no = $receiptData->voucher_no;
                $receipt->approved_at = now();
                $receipt->approved_by = $receiptData->user_id;


                //update-sales-activity-total-paid-amount
                if ($receipt->save()) {

                    if ($saleActivity->total_paid_amount) {
                        $saleActivity->total_paid_amount = $saleActivity->total_paid_amount + $receipt->amount;
                    } else {
                        $saleActivity->total_paid_amount = $receipt->amount;
                    }
                    $saleActivity->save();
                }

                //receipt-created
                $receiptData->is_created = 1;
                $receiptData->save();
            }
            DB::commit();
            return true;
        } catch (\Throwable $th) {

            info($th);
            info($client);
            DB::rollBack();
            return false;
        }
    }
}
