<?php

namespace App\Console\Commands;

use App\ClientDetailsFromQuadra;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class FetchClientDetailsFromQuadra extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fetch:clients-from-quadra';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fetch clients details from quadra.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        DB::beginTransaction();
        try {
            $clientDetailsFromQuadra = ClientDetailsFromQuadra::all();

            foreach ($clientDetailsFromQuadra as $clientDetail) {

                $response = Http::post('http://182.18.157.133:8090/api/MobAppReceiptDetails', [
                    'ClientId' => $clientDetail->client_id,
                ]);
                $data = $response->json();
                if (isset($data['paymentDetails'])) {
                    $clientDetail->client_name_api = $data['paymentDetails'][0]['Client'];
                    $clientDetail->unit_no = $data['paymentDetails'][0]['PropertyID'];
                    $clientDetail->sales_person = $data['paymentDetails'][0]['SalesPerosn'];
                    $clientDetail->save();
                }
            }

            info('all clients details from quadra updated on table');
            DB::commit();
            return true;
        } catch (\Throwable $th) {
            info('there is an error for fetch clients details from quadra updated on table');
            info($th);
            DB::rollBack();

            return false;
        }
    }
}
