<?php

namespace App\Console\Commands;

use App\Lead;
use App\LeadReAllocationLog;
use Illuminate\Console\Command;

class LeadsBackupCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'leads:backup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $logLeadsIds=LeadReAllocationLog::distinct('lead_id')->pluck('lead_id');
        $idsCollection=collect($logLeadsIds);

        foreach($idsCollection as $logId){
            $logLead=LeadReAllocationLog::where('lead_id',$logId)->first();
            $lead=Lead::find($logLead->lead_id);
            $lead->attended_by=$logLead->allocated_to;
            $lead->allocation_date=$logLead->allocation_date;
            $lead->allocated_by=$logLead->allocated_by;
            $lead->save();
        }
    }
}
