<?php

namespace App\Console\Commands;

use App\Lead;
use App\LeadBank;
use Illuminate\Console\Command;

class LeadsToLeadBankMigrateCommand extends Command
{

    protected $signature = 'migrate:leads-to-lead-bank';


    protected $description = 'This command will migrate all unique leads to leads bank table';


    public function __construct()
    {
        parent::__construct();
    }


    public function handle()
    {
        $totalLeads = Lead::where('migrated', 0)->count();
        $processedLeads = 0;
        Lead::where('migrated', 0)->chunk(5000, function ($leads) use (&$processedLeads, $totalLeads) {
            foreach ($leads as $lead) {
                $length = -10;

                if (strlen($lead->mobile) == 9) {
                    $length = -9;
                }
                if (strlen($lead->mobile) == 8) {
                    $length = -8;
                }
                $mobileNumber = substr($lead->mobile, $length);
                $existingLead = LeadBank::where('mobile', 'LIKE', '%' . $mobileNumber)->first();
                if($lead->mobile == null){
                    $existingLead = LeadBank::where('email',  $lead->email)->first();
                }
                if (!$existingLead) {
                    LeadBank::create([
                        'lead_id' => $lead->id,
                        'pref_name' => $lead->pref_name,
                        'enquirer_name' => $lead->enquirer_name,
                        'email' => $lead->email,
                        'phone_code' => $lead->phone_code,
                        'duplicate_entry' => $lead->duplicate_entry,
                        'mobile' => $lead->mobile,
                        'pan_no' => $lead->pan_no,
                        'aadhaar' => $lead->aadhaar,
                        'alt_mobile' => $lead->alt_mobile,
                        'whatsapp_no' => $lead->whatsapp_no,
                        'source' => $lead->source,
                        'project_type' => $lead->project_type,
                        'preferred_project' => $lead->preferred_project,
                        'budget' => $lead->budget,
                        'attended_by' => $lead->attended_by,
                        'remarks' => $lead->remarks,
                        'comment' => $lead->comment,
                        'gender' => $lead->gender,
                        'dob' => $lead->dob,
                        'age' => $lead->age,
                        'self_occupancy' => $lead->self_occupancy,
                        'profession' => $lead->profession,
                        'phone_office' => $lead->phone_office,
                        'address' => $lead->address,
                        'country' => $lead->country,
                        'state' => $lead->state,
                        'location_id' => $lead->location_id,
                        'residential_status' => $lead->residential_status,
                        'city' => $lead->city,
                        'village' => $lead->village,
                        'desom' => $lead->desom,
                        'post' => $lead->post,
                        'taluk' => $lead->taluk,
                        'present_address' => $lead->present_address,
                        'present_pincode' => $lead->present_pincode,
                        'organization' => $lead->organization,
                        'designation' => $lead->designation,
                        'department' => $lead->department,
                        'lead_date' => $lead->lead_date,
                        'unique_id' => $lead->unique_id,
                        'status' => $lead->status,
                        'created_by' => $lead->created_by,
                    ]);
                }
                $lead->update(['migrated' => 1]);
                $processedLeads++;
                $processingPercentage = ($processedLeads / $totalLeads) * 100;
                $this->info("Migrating:" . number_format($processingPercentage, 2) . "%");
            }
        });
    }
}
