<?php

namespace App\Console\Commands;

use App\RetailSaleActivityStore;
use App\SalesActivity;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class LinkCustomerCodeSale extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'create:link-customer-code';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        DB::beginTransaction();
        try {
            $sales = RetailSaleActivityStore::where('project_id', 16)->where('status', 1)->get();

            foreach ($sales as $sale) {
                $SaleActivity = SalesActivity::with('getLeads')->whereHas('getLeads', function ($q) use ($sale) {
                    $q->where('email',$sale->email)->orwhere('enquirer_name', $sale->name);
                })->where('import_sale',1)->where('project',16)->where('cust_status',0)->first();
                if ($SaleActivity) {
                    // Update the field in the SalesActivity model
                    $SaleActivity->customer_code = $sale->customer_code;
                    $SaleActivity->cust_status = 1;
                    $SaleActivity->sale_ref_number =  $sale->customer_code;
                    $SaleActivity->save();
                }
            }

            DB::commit();
            return true;
        } catch (\Throwable $th) {
            info($th);
            DB::rollBack();
            return false;
        }
    }
   
}