<?php

namespace App\Console\Commands;

use App\HiIncome;
use App\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class LinkIncomeUsers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'link:income-users';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Linking users with income for report';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        DB::beginTransaction();
        try {

            $incomes = HiIncome::where('updated_user',0)->get();
            
            foreach ($incomes as $income) {
                $hiusers = User::where('old_id',$income->sale_person_id)->first();
            
                if($hiusers){
                            $income->sale_person_id = $hiusers->id;
                            $income->updated_user = 1;
                            $income->save();
                    }
                  
                }
               
           
            DB::commit();
           
            return true;
        } catch (\Throwable $th) {

            info($th);
        
            DB::rollBack();
            return false;
        }
    }
}
