<?php

namespace App\Console\Commands;

use App\Lead;
use App\Proposal;
use App\RetailSaleActivityStore;
use App\SalesActivity;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class LinkSaleIdReceipt extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update:retail-lead-id-receipt';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sale activity id linking to receipt table';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        DB::beginTransaction();
        try {
         
    $sales = SalesActivity::where('project', 20)->where('import_sale', 1)->get();

    foreach ($sales as $sale) {
        $customerCode = $sale->customer_code;
        $retailSale = RetailSaleActivityStore::where('customer_code', $customerCode)->where('project_id', 20)->first();

        if ($retailSale) {
            $name = $retailSale->name;
            $lead = Lead::where('enquirer_name', 'LIKE', '%' . $name . '%')
                ->where('lead_stage_id', 7)
                ->where('sale_status', 'yes')
                ->first();

            if ($lead) {
                $leadId = $lead->id;

                $sale->update([
                    'lead_id' => $leadId,
                    'link_code'=>1
                ]);

                $proposalId = $sale->proposal_id;
                $proposal = Proposal::find($proposalId);

                if ($proposal) {
                    $proposal->update([
                        'lead_id' => $leadId,
                        'name' => $lead->enquirer_name
                    ]);
                }

                $sale->getOldReceipts()->update([
                    'client_id' => $leadId
                ]);
            }
        }
      
       
    }
    DB::commit();
    return true;
           
        } catch (\Throwable $th) {

            dd($th);

            DB::rollBack();
            return false;
        }
    }
}



