<?php

namespace App\Console\Commands;

use App\Lead;
use App\PriceList;
use App\SalesActivity;
use App\QuadraCustomer;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class QuadraCustomerUpdate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update:quadra-customer-update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Quadra Customer Update';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        DB::beginTransaction();
        try {

            $quadra_customers = QuadraCustomer::get();


            foreach ($quadra_customers as $quadra_customer) {
                $pricelist = PriceList::where('ap_no', 'like', '%' . $quadra_customer->unit_no . '%')->where('project_id',17)->first();

                if ($pricelist) {


                   SalesActivity::where('project_unit', $pricelist->id)
                        ->update([
                            'quadra_customer_id' => $quadra_customer->client_id
                        ]);
                }
            }

            DB::commit();

            return true;
        } catch (\Throwable $th) {

            info($th);

            DB::rollBack();
            return false;
        }
    }
}
