<?php

namespace App\Console\Commands;

use App\Receipt;
use App\RetailReceipts;
use App\SalesActivity;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class RetailReceiptStore extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'create:retail-receipt-store';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Retail Receipt Store';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        DB::beginTransaction();
        try {
            $receipts = RetailReceipts::where('status', 0)->where('project_id',16)->get();
            foreach ($receipts as $receipt) {
                $saleActivity = SalesActivity::where('customer_code',$receipt->customer_code)->where('import_sale',1)->first();
               
                if($saleActivity){
                    $totalAmount = $saleActivity->total_paid_amount;
                    if($receipt->cheque_no =='FT/NEFT'){
                        $modeofpayment = 'EFT';
                        $cheque_no = null;

                    }
                    else{
                        $modeofpayment = 'Cheque';
                        $cheque_no = $receipt->cheque_no;
                    }
                   
                  
                    $newReceipt = new Receipt();
                    $newReceipt->client_id = $saleActivity->lead_id;
                    $newReceipt->project_id = $saleActivity->project;
                    $newReceipt->sale_id = $saleActivity->id;
                    $newReceipt->unit_id = 0;
                    $newReceipt->user_id = 1;
                    $newReceipt->currency = 'INR';
                    $newReceipt->receipt_no = $receipt->receipt_no;
                    $newReceipt->receipt_date = $receipt->cleared_date; 
                    $newReceipt->clearing_date = $receipt->cleared_date;
                    $newReceipt->mode_of_payment = $modeofpayment;
                    $newReceipt->cheque_no = $cheque_no;
                    $newReceipt->amount = $receipt->amount;
                    $newReceipt->cheque_date = $receipt->cheque_date;
                    $newReceipt->is_approved = 1;
                    $newReceipt->approved_at = $receipt->cleared_date;
                    $newReceipt->old_receipt = 1;
                    $newReceipt->approved_by = 1;
                    if($newReceipt->save()){
                        $receipt->update(['status'=>1]);
                        $receiptAmount = Receipt::where('sale_id',$saleActivity->id)->sum('amount');
                        $saleActivity->update(['total_paid_amount'=>$receiptAmount]);


                    }
                      

                }

              
            }
            DB::commit();
            return true;
          
        } catch (\Throwable $th) {
            info($th);
            DB::rollBack();
            return false;
        }
    }
}

