<?php

namespace App\Console\Commands;

use App\Bank;
use App\Lead;
use App\Location;
use App\SalesActivity;
use App\RetailSaleActivityStore;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class RetailSalesActivityStoreNew extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'create:retail-sale-activity-store';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'New Lead Creation and retail Sale Activity storing';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        DB::beginTransaction();
        try {
            $sales = RetailSaleActivityStore::where('status', 0)->where('project_id', 40)->get();

            foreach ($sales as $sale) {
                $location = Location::find($sale->district);
                $location_name = '';
                if ($location) {
                    $location_name = $location->name;
                }

                $bank = Bank::find($sale->beneficary_bank_id);
                if ($bank) {
                    $bankname = $bank->name;
                } else {
                    $bankname = '';
                }
                if ($sale->gender == 'M') {
                    $gender = 'Male';
                } else {
                    $gender = 'Female';
                }

                $lead = new Lead();
                $lead->email = $sale->email;
                $lead->enquirer_name = $sale->name;
                $lead->mobile = $sale->phone_no;
                $lead->dob = $sale->dob;
                $lead->gender = $gender;
                $lead->guardian_name = $sale->father_name ?: $sale->spouse_name;
                $lead->remarks = $sale->remarks;
                $lead->address = $sale->address1.' '.$sale->address2.' '.$sale->address3;
                $lead->pin = $sale->pin;
                $lead->state = $sale->state;
                $lead->location_id = $sale->district;
                $lead->location = $location_name;
                $lead->beneficiary_name = $sale->beneficary_ac_name;
                $lead->bank_account_number = $sale->benificary_ac_no;
                $lead->beneficiary_branch = $sale->branch;
                $lead->beneficiary_bank_name = $bankname;
                $lead->ifsc_code = $sale->ifsc;
                $lead->pan_no = $sale->pan_no;
                $lead->aadhaar = $sale->aadhaar;
                $lead->created_by = 1;
                $lead->sale_status = 'yes';
                $lead->attended_by = 314;
                $lead->lead_stage_id = 7;
                $lead->preferred_project = $sale->project_id;
                if ($lead->save()) {
                    $saleActivity = new SalesActivity();
                    $saleActivity->lead_id = $lead->id;
                    $saleActivity->customer_code = $sale->customer_code;
                    $saleActivity->no_of_unit = $sale->units;
                    $saleActivity->project = $sale->project_id;
                    $saleActivity->sales_date = $sale->sale_date;
                    $saleActivity->proposal_id = 10835;
                    $saleActivity->project_unit = null;
                    $saleActivity->sales_owner = $sale->sales_person;
                    $saleActivity->project_value = $sale->investment_value ?? 2000000;
                    $saleActivity->grand_total = $sale->investment_value ?? 2000000;
                    $saleActivity->booking_status = 'booked';
                    $saleActivity->is_verified = 1;
                    $saleActivity->import_sale = 1;

                    if ($saleActivity->save()) {
                        $sale->update(['status' => 1]);
                    }
                }
            }
            DB::commit();

            return true;
        } catch (\Throwable $th) {
            info($th);

            DB::rollBack();

            return false;
        }
    }
}
