<?php

namespace App\Console\Commands;

use App\Bank;
use App\Lead;
use App\Location;
use App\PreferredProject;
use App\Proposal;
use App\RetailSaleActivityStore;
use App\SalesActivity;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use PDF;

class RetailSaleStore extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'create:retail-sale-store';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Retail Sale Activity Store';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */

     public function handle()
     {
         DB::beginTransaction();
         try {

             $sales = RetailSaleActivityStore::where('status', 0)->get();
         

             foreach ($sales as $sale) {
                 $location = Location::find($sale->district);
                 $location_name = '';
                 if ($location) {
                     $location_name = $location->name;
                 }

                 $bank = Bank::find($sale->beneficary_bank_id);
                 if ($bank) {
                     $bankname = $bank->title;
                 } else {
                     $bankname = '';
                 }
                 if ($sale->gender == 'M') {
                     $gender = 'Male';
                 } else {
                     $gender = 'Female';
                 }
                 $project = PreferredProject::find($sale->project_id);
                 

                 $lead = new Lead();
                 $lead->email = $sale->email;
                 $lead->enquirer_name = $sale->name;
                 $lead->mobile = $sale->phone_no;
                 $lead->dob = $sale->dob;
                 $lead->gender = $gender;
                 $lead->guardian_name = $sale->father_name ?: $sale->spouse_name;
                 $lead->remarks = $sale->remarks;
                 $lead->address = $sale->address1 . ',' . $sale->address2 . ',' . $sale->address3;
                 $lead->pin = $sale->pin;
                 $lead->state = $sale->state;
                 $lead->location_id = $sale->district;
                 $lead->location = $location_name;
                 $lead->beneficiary_name = $sale->beneficary_ac_name;
                 $lead->bank_account_number    = $sale->benificary_ac_no;
                 $lead->beneficiary_branch = $sale->branch;
                 $lead->beneficiary_bank_name = $bankname;
                 $lead->ifsc_code	 = $sale->ifsc_code;
                 $lead->pan_no = $sale->pan_no;
                 $lead->aadhaar = $sale->aadhaar;
                 $lead->created_by = 1;
                 $lead->attended_by = 1;
                 $lead->sale_status = 'yes';
                 $lead->lead_stage_id = 7;
                 $lead->preferred_project = $sale->project_id;
                 if ($lead->save()) {
                    $proposal = new Proposal();
                    $proposal->project_id =$sale->project_id;
                    $proposal->lead_id = $lead->id;
                    $proposal->project_type=$project->project_type;
                    $proposal->name = $lead->enquirer_name;
                    $proposal->phone = $lead->mobile;
                    $proposal->email = $lead->email;
                    $proposal->preferred_project = $project->project_name;
                    $proposal->proposal_status = 'final';
                    $proposal->option_1 = 1;
                    $proposal->option_2 =3;
                    $proposal->option_3 =5;
                    $proposal->share_price = $project->share_amount;
                    $proposal->administration_cost = $project->administration_cost;
                    $proposal->project_monthly_return =$project->share_return;
                    if($proposal->save()){
                        
                // if ($proposal->project_id == 25 || $proposal->project_id == 26 || $proposal->project_id == 27) {
                //     $pdf = \PDF::loadView('dashboard.Retail.retail-mannarkad-pdf', [
                //         'proposel' => $proposal,

                //         'project' => $project,

                //     ]);
                // } else {

                //     $pdf = \PDF::loadView('dashboard.Retail.retail-pdf', [
                //         'proposel' => $proposal,
                //         'project' => $project,

                //     ]);
                // }


                // $fileName = 'uploads/proposals/leads/' . $proposal->pref_name . $proposal->name . '_' . $proposal->id . '.pdf';
                // $pdf->save($fileName);
                // $proposal->file = $fileName;
                // $proposal->save();
                     
                     $saleActivity = new SalesActivity();
                     $saleActivity->lead_id =  $lead->id;
                     $saleActivity->customer_code = $sale->customer_code;
                     $saleActivity->no_of_unit = $sale->units;
                     $saleActivity->project = $sale->project_id;
                     $saleActivity->sales_date = $sale->sale_date;
                     $saleActivity->proposal_id = $proposal->id;
                     $saleActivity->project_unit = null;
                     $saleActivity->sales_owner = $sale->sales_person;
                     $saleActivity->project_value = $sale->investment_value;
                     $saleActivity->grand_total = $sale->investment_value;
                     $saleActivity->booking_status = 'booked';
                     $saleActivity->is_verified = 1;
                     $saleActivity->import_sale = 1;

                     if ($saleActivity->save()) {
                         $sale->update(['status' => 1]);
                     }

                    }


                 }


             }
             
             DB::commit();

             return true;
         } catch (\Throwable $th) {

             info($th);

             DB::rollBack();
             return false;
         }
     }
}