<?php

namespace App\Console\Commands;

use App\Lead;
use App\PreferredProject;
use App\PriceList;

use App\SalesActivity;
use App\SalesActivityStore;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class SaleActivityStore extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature ='create:sale-activity-store';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'New Lead Creation and Sale Activity storeing';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        DB::beginTransaction();
        try {

            $sales = SalesActivityStore::where('status',0)->get();
            
           
            $currentDate = Carbon::now();

            // Format the current date to "Y-m-d" format
            $formattedDate = $currentDate->format('Y-m-d');
            foreach ($sales as $sale) {
                $pricelist = PriceList::where('ap_no', 'like', '%' . $sale->ap_no . '%')
                ->where('project_id', 'like', '%' . $sale->project_id . '%')
                ->first();
                $project = PreferredProject::find($sale->project_id);
                $project_type = $project->project_type;
                if($pricelist){
                    $unitId = $pricelist->id;
                    
                    $saleActivity = SalesActivity::where('project_unit',$unitId)->first();
                    if(!$saleActivity){
                       
                        $lead = new Lead();
                        $lead->email = $sale->email;
                        $lead->enquirer_name = $sale->customer_name;
                        $lead->mobile = $sale->phone_no;
                        $lead->attended_by = 1;
                        $lead->created_by = 1;
                        $lead->address = $sale->address;
                        $lead->sale_status ='yes';
                        $lead->lead_stage_id = 7;
                        $lead->preferred_project = $sale->project_id;
                        $lead->project_type =  $project_type;

                        if($lead->save()){
                            
                            $saleActivity = new SalesActivity();
                            $saleActivity->lead_id =  $lead->id;
                            $saleActivity->project = $sale->project_id;
                            $saleActivity->proposal_id = 1;
                            $saleActivity->quadra_customer_id = $sale->client_id;
                            $saleActivity->project_unit = $unitId;
                            $saleActivity->sales_owner = $sale->sale_person_id;
                            $saleActivity->project_value = $sale->grand_total;
                            $saleActivity->grand_total = $sale->grand_total;
                            $saleActivity->sales_date = $formattedDate;

                            $saleActivity->booking_status ='booked';
                            $saleActivity->import_sale = 1;
                            $saleActivity->is_verified = 1;
                            if($saleActivity->save()){
                                $sale->update(['status'=>1]);
                            }
                            
                        }

                    }
                }
                else{
                   
                    $lead = new Lead();
                    $lead->email = $sale->email;
                    $lead->enquirer_name = $sale->customer_name;
                    $lead->mobile = $sale->phone_no;
                    $lead->attended_by = 1;
                    $lead->created_by = 1;
                    $lead->sale_status ='yes';
                    $lead->lead_stage_id = 7;
                    $lead->preferred_project = $sale->project_id;
                    $lead->project_type =  $project_type;
                    if($lead->save()){
                        $priceList = new PriceList();

                        $priceList->project_id = $sale->project_id;
                        $priceList->ap_no = $sale->ap_no;
                        $priceList->sale_value = $sale->grand_total;
                        $priceList->grand_total = $sale->grand_total;
                        $priceList->rate_per_sqft = $sale->rate_per_sqft;
                        $priceList->taxable_amount = 0;
                        $priceList->floor = 0;
                        $priceList->carpet_area = 0;
                        $priceList->save();
                       
                        $saleActivity = new SalesActivity();
                        $saleActivity->lead_id =  $lead->id;
                        $saleActivity->project = $sale->project_id;
                        $saleActivity->proposal_id = 1;
                        $saleActivity->project_unit = $priceList->id;
                        $saleActivity->quadra_customer_id = $sale->client_id;
                        $saleActivity->sales_owner = $sale->sale_person_id;
                        $saleActivity->project_value = $sale->grand_total;
                        $saleActivity->grand_total = $sale->grand_total;
                        $saleActivity->sales_date = $formattedDate;
                        $saleActivity->booking_status ='booked';
                        $saleActivity->is_verified = 1;
                        $saleActivity->import_sale = 1;
                     
                        if($saleActivity->save()){
                            $sale->update(['status'=>1]);
                        }
                    }
              
                }
                
            }
           
            DB::commit();
          
            return true;
        } catch (\Throwable $th) {

            dd($th);
        
            DB::rollBack();
            return false;
        }
    }
}
