<?php

namespace App\Console\Commands;

use App\Lead;
use App\PreferredProject;
use App\PriceList;

use App\SalesActivity;
use App\SalesActivityStore;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class SalePhoneFromLead extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature ='create:sale-lead-store';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sale Activity lead store';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {
            $salesActivities = SalesActivity::all();
            $totalActivities = $salesActivities->count();
            $processedActivities = 0;
            foreach($salesActivities as $salesActivity){
                $lead = Lead::find($salesActivity->lead_id);
                    if(filled($lead)){
                        $updates = [
                            //sales-activity-column => lead-column
                            'phone_code' => 'phone_code',
                            'mobile' => 'mobile',
                            'alt_mobile' => 'alt_mobile',
                           
                        ];

                        foreach ($updates as $activityField => $leadField) {
                            if (is_null($salesActivity->$activityField)) {
                                $salesActivity->$activityField = $lead->$leadField;
                            }
                        }
                        $salesActivity->save();
                    }

                    $processedActivities++;
                    $progressPercentage = ($processedActivities / $totalActivities) * 100;
                    $this->output->write("\rProcessed $processedActivities out of $totalActivities sales activities ($progressPercentage%)");
            }
            $this->info("\nData transfer completed.");
        } catch (\Throwable $th) {
            $this->error("An error occurred: " . $th->getMessage());
        }

    }
}
