<?php

namespace App\Console\Commands;

use App\DailyActivityCalculation;
use App\DailyWorkEfficiency;
use App\Lead;
use App\Task;
use App\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class WorkEfficiencyCalculatorDate extends Command
{
    protected $signature = 'calculate:work-efficiency-date';

    protected $description = 'This command will calculate and update the daily work efficiency of users based on their tasks date wise';

    public function handle()
    {
        $users = User::where('status', 1)
            ->where(function ($query) {
                $query->whereHas('roles', function ($q) {
                    $q->where('role_id', 8);
                })->where('status', 1);
            })->get();
        $today = '2023-11-19';

        foreach ($users as $user) {
            $tasks = Task::where('created_by', $user->id)
                ->where('task_completed_status', 1)
                ->whereDate('schedule_date', $today)
                ->whereIn('create_task_id', [2, 3, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19])
                ->where(function ($query) {
                    $query->whereIn('create_task_id', [2, 3, 12, 13, 14, 19])
                        ->where('team_leader_approved', 1);
                })
                ->orWhere(function ($query) use ($user, $today) {
                    $query->where('created_by', $user->id)
                        ->whereIn('create_task_id', [10, 11, 15, 16, 17, 18])
                        ->whereDate('schedule_date', $today)
                        ->where('task_completed_status', 1);
                })

                ->select('tasks.*', DB::raw('(SELECT MAX(point) FROM daily_activity_calculations WHERE create_task_id = tasks.create_task_id) as max_point'))
                ->get()
                ->groupBy('lead_id');


            $tasks->transform(function ($leadTasks) {
                return $leadTasks->sortByDesc('max_point')->first();
            });

            $leadsToSkip = $tasks->pluck('lead_id');

            $leads = Lead::where('created_by', $user->id)
                ->whereDate('created_at', $today)
                ->where('duplicate_entry', 'no')
                ->where('is_attended', 1)
                ->whereNotIn('id', $leadsToSkip)
                ->get();


            $calculations = DailyActivityCalculation::get();
            $leadPoint = DailyActivityCalculation::find(1)->point ?? 0;

            $appointments = $tasks->where('create_task_id', 3)->count();
            $appointmentPoint = $calculations->where('create_task_id', 3)->first()->point;
            $totalAppointmentPoint = $appointments * $appointmentPoint;

            $siteVisit = $tasks->where('create_task_id', 2)->count();
            $sitePoint = $calculations->where('create_task_id', 2)->first()->point;
            $totalSitePoint = $siteVisit * $sitePoint;

            $officeVisit = $tasks->where('create_task_id', 13)->count();
            $OfficePoint = $calculations->where('create_task_id', 13)->first()->point;
            $totalOfficePoint = $officeVisit * $OfficePoint;

            $virtual = $tasks->where('create_task_id', 12)->count();
            $virtualPoint = $calculations->where('create_task_id', 12)->first()->point;
            $totalVirtualPoint = $virtual * $virtualPoint;

            $directMarketing = $tasks->where('create_task_id', 11)->count();
            $directMarketingPoint = $calculations->where('create_task_id', 11)->first()->point;
            $totalDirectMarketingPoint = $directMarketing * $directMarketingPoint;

            $mallCounter = $tasks->where('create_task_id', 10)->count();
            $mallCounterPoint = $calculations->where('create_task_id', 10)->first()->point;
            $totalMallCounterPoint =  $mallCounter * $mallCounterPoint;

            $fresh = $tasks->where('create_task_id', 15)->count();
            $freshRuno = $tasks->where('create_task_id', 17)->where('duration', '>=', 30)->count();
            $freshCall =  $fresh + $freshRuno;
            $freshCallPoint = $calculations->where('create_task_id', 15)->first()->point;
            $totalFreshCallPoint = $freshCall  * $freshCallPoint;

            $freshNri = $tasks->where('create_task_id', 16)->count();
            $freshNriRuno = $tasks->where('create_task_id', 18)->where('duration', '>=', 30)->count();
            $freshCallNriPoint = $calculations->where('create_task_id', 16)->first()->point;
            $freshCallNri = $freshNri + $freshNriRuno;
            $totalFreshCallNriPoint = $freshCallNri * $freshCallNriPoint;

            $connectHeads = $tasks->where('create_task_id', 14)->count();
            $connectHeadsPoint = $calculations->where('create_task_id', 14)->first()->point;
            $totalConnectHeadsPoint = $connectHeads * $connectHeadsPoint;

            // $followUpCalls = $tasks->where('create_task_id', 19)->where('duration', '>=', 120)->count();
            // $followUpCallPoint = $calculations->where('create_task_id', 19)->first()->point;
            // $totalFollowUpCallPoint =  $followUpCalls * $followUpCallPoint;

            $followuptasks = $tasks->where('create_task_id', 19);
            $countWithNullImageAndDuration = $followuptasks->filter(function ($task) {
                return $task->image == null && $task->duration >= 120;
            })->count();

            $countWithNotNullImageAndTeamLeaderApprove = $followuptasks->filter(function ($task) {
                return $task->image != null && $task->team_leader_approved == 1;
            })->count();
            $followUpCalls = $countWithNullImageAndDuration + $countWithNotNullImageAndTeamLeaderApprove;
            $followUpCallPoint = $calculations->where('create_task_id', 19)->first()->point;
            $totalFollowUpCallPoint = number_format($followUpCalls * $followUpCallPoint, 3);

            $newLeadCount =  $leads->count();
            $leadCalculation = $newLeadCount * $leadPoint;

            $data = [
                'totalAppointmentPoint' => $totalAppointmentPoint,
                'totalSitePoint' => $totalSitePoint,
                'totalOfficePoint' => $totalOfficePoint,
                'totalVirtualPoint' => $totalVirtualPoint,
                'totalDirectMarketingPoint' => $totalDirectMarketingPoint,
                'totalMallCounterPoint' => $totalMallCounterPoint,
                'leadCalculation' => $leadCalculation,
                'totalFreshCallPoint' => $totalFreshCallPoint,
                'totalConnectHeadsPoint' => $totalConnectHeadsPoint,
                'totalFreshCallNriPoint' => $totalFreshCallNriPoint,
                'totalFollowUpCallPoint' => $totalFollowUpCallPoint,
            ];

            $totalPoints = array_sum($data);

            DailyWorkEfficiency::updateOrCreate(
                [
                    'user_id' => $user->id,
                    'date' => $today
                ],
                [
                    'work_efficiency' => $totalPoints,
                    'user_name' => $user->name,
                    'team_leader_id' => $user->getReportingTo->id,
                    'branch_id' => $user->branch_id,
                ],
            );
        }
    }
}
