<?php

namespace App\Console;

use Mail;
use App\Lead;
use App\Task;
use App\Console\Commands\BulkContactMail;
use Illuminate\Console\Scheduling\Schedule;
use App\Actions\BulkMail\SendBulkMailAction;
use App\Console\Commands\RetailSaleActivityStore;
use App\Console\Commands\RetailSalesActivityStoreNew;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        BulkContactMail::class,
        RetailSalesActivityStoreNew::class
    ];


    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly();
        // $schedule->call(function () {
        //     date_default_timezone_set("Asia/Calcutta");
        //     $today = date('Y-m-d');
        //     $leads = Lead::whereDate('created_at', $today)->select('*')->orderBy('created_at', 'desc')->get();

        //     $tasks = Task::join('leads', 'leads.id', '=', 'tasks.lead_id')->where('tasks.created_at', $today)->select('tasks.*', 'leads.enquirer_name', 'leads.phone_code', 'leads.mobile', 'leads.id as leadId')->orderBy('created_at', 'desc')->get();

        //     $to = 'rajeesh@meridian.net.in';
        //     $cc1 = 'shabeeb@meridian.net.in';
        //     //$cc2 = 'pentiumadvt@gmail.com';
        //     //  $to = 'anishanp@meridian.net.in';
        //     //$cc1 = 'rajeesh@meridian.net.in';
        //     $details = [
        //         'leads' => $leads,
        //         'tasks' => $tasks,

        //     ];

        //     //     \Mail::to($to)->cc([$cc1])->send(new \App\Mail\DailyReport2Mail($details));
        //     // })->everyFiveMinutes();
        //     //  echo date("H:i");
        //     if (date("H:i") == "19:00") {
        //         \Mail::to($to)->cc([$cc1])->send(new \App\Mail\DailyReport2Mail($details));
        //     }
        // })->everyFiveMinutes();


        $schedule->command('auto:bulk-contact-mail')->everyFiveMinutes();

        //temp-commented
        $schedule->command('auto:lead-distribution')->everyFiveMinutes();
        $schedule->command('send-back:re-allocation')->everyFiveMinutes();
        $schedule->command('calculate:work-efficiency')->everyFiveMinutes();
        $schedule->command('queue:work --stop-when-empty')
        ->everyMinute()
        ->withoutOverlapping();



        // $schedule->call(function () {
        //     $mail = new SendBulkMailAction();
        //     $mail();
        // })->everyMinute();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');


        require base_path('routes/console.php');
    }
}
