<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ContactList extends Model
{
    use SoftDeletes;
    protected $table = 'contact_lists';
    protected $primaryKey = 'id';
    public $timestamps = false;
    protected $guarded = [];


    public function getContactGroup()
    {
        return $this->belongsTo(ContactGroup::class, 'contact_group_id', 'id');
    }
    public function getProject()
    {
        return $this->belongsTo(PreferredProject::class, 'interested_project', 'id');
    }
}
