<?php

namespace App\CustomerApp\Http\Controllers\Api\V1\Auth;

use App\Api\Http\Controllers\Controller;
use App\Customer;
use App\CustomerApp\Http\Requests\Api\V1\Auth\GuestLoginRequest;
use App\CustomerApp\Http\Requests\Api\V1\Auth\LoginRequest;
use App\CustomerApp\Http\Requests\Api\V1\Auth\VerifyOtpRequest;
use App\CustomerApp\Http\Resources\Customer\CustomerResource;
use App\Traits\ApiResponse;
use App\TwoFactorCode;

class GuestLoginController extends Controller
{
    use ApiResponse;

    public function login(GuestLoginRequest $request)
    {
        try {
            $customer = Customer::where('mobile', $request->phone)->where('type', 'customer')->first();
            if (filled($customer)) {
                return $this->errorResponse('This phone number is already associated with a customer account. Please log in using your customer credentials.');
            }
            TwoFactorCode::updateOrCreate(
                [
                    'phone_number' => $request->phone,
                ],
                ['code' => 1234]
            )->touch();
            return $this->successResponse('Verification code sent successfully');
        } catch (\Throwable $th) {
            return $this->errorResponse('Failed to send verification code, Please try again!');
        }
    }

    public function verifyOtp(VerifyOtpRequest $request)
    {
        $twoFactorCode = TwoFactorCode::firstWhere('phone_number', $request->phone);
        if ($twoFactorCode->updated_at->lt(now()->subMinutes(30))) {
            return $this->errorResponse('Your verification code is expired!');
        }
        if ($twoFactorCode->code != $request->code) {
            return $this->errorResponse('Invalid verification code entered!');
        }
        $responseData = (object) [];
        $customer = Customer::where('mobile', $request->phone)->where('type', 'guest')->first();
        if (filled($customer)) {
            $token = $customer->createToken('guest')->plainTextToken;
            $responseData = new CustomerResource($customer, $token);
        }
        return $this->successResponse('Verified successfully', $responseData);
    }
}
