<?php

namespace App\CustomerApp\Http\Controllers\Api\V1\Auth;

use App\Api\Http\Controllers\Controller;
use App\CustomerApp\Http\Requests\Api\V1\Auth\LoginRequest;
use App\CustomerApp\Http\Resources\Customer\CustomerResource;
use App\Traits\ApiResponse;

class LoginController extends Controller
{
    use ApiResponse;

    public function login(LoginRequest $request)
    {
        try {
            $credentials = ['username' => $request->username, 'password' => $request->password];
            if (auth()->guard('customer')->attempt($credentials)) {
                $customer = auth()->guard('customer')->user();
                saveCustomerTokens($customer->id, $request->device_type, $request->device_name, $request->device_id, $request->push_token);
                $token = $customer->createToken('customer')->plainTextToken;
                return $this->successResponse('Login successful', new CustomerResource($customer, $token));
            }
            return $this->errorResponse('Invalid Credentials!');
        } catch (\Throwable $th) {
            return $this->errorResponse('Authentication failed!');
        }
    }

    public function logout()
    {
        $customer = auth()->user();
        $customer->tokens()->delete();
        $customer->pushTokens()->delete();
        return $this->successResponse('Logged out successfully');
    }
}
