<?php

namespace App\CustomerApp\Http\Controllers\Api\V1\Auth;

use App\Api\Http\Controllers\Controller;
use App\Customer;
use App\CustomerApp\Http\Requests\Api\V1\Auth\RegisterRequest;
use App\CustomerApp\Http\Resources\Customer\CustomerResource;
use App\Traits\ApiResponse;

class RegisterController extends Controller
{
    use ApiResponse;

    public function register(RegisterRequest $request)
    {
        try {
            $customer = Customer::create([
                'name_prefix' => $request->name_prefix,
                'name' => $request->name,
                'mobile' => $request->phone,
                'residential_status' => $request->residential_status,
                'email' => $request->email,
                'location' => $request->location,
                'type' => 'guest',
            ]);
            $token = $customer->createToken('guest')->plainTextToken;
            $responseData = new CustomerResource($customer, $token);
            return $this->successResponse('Registered successfully', $responseData);
        } catch (\Throwable $th) {
            return $this->errorResponse('Failed to complete registration, Please try again');
        }
    }
}
