<?php

namespace App\CustomerApp\Http\Controllers\Api\V1\ContactUs;

use App\Api\Http\Controllers\Controller;
use App\CustomerApp\Http\Requests\Api\V1\ContactUs\GetContactUsRequest;
use App\CustomerApp\Http\Resources\PreferredProject\PreferredProjectResource;
use App\PreferredProject;
use App\Traits\ApiResponse;

class ContactUsController extends Controller
{
    use ApiResponse;

    public function index(GetContactUsRequest $request)
    {
        try {
            $project = PreferredProject::find($request->project_id);
            return $this->successResponse('Contact Us', new PreferredProjectResource($project));
        } catch (\Throwable $th) {
            return $this->errorResponse('Failed to fetch contact us details!');
        }
    }
}
