<?php

namespace App\CustomerApp\Http\Controllers\Api\V1\Projects;

use App\Api\Http\Controllers\Controller;
use App\CustomerApp\Http\Resources\PreferredProject\ProjectCollection;
use App\PreferredProject;
use App\Traits\ApiResponse;

class ProjectsController extends Controller
{
    use ApiResponse;

    public function index()
    {
        try {
            $projects = PreferredProject::where('status', 1)->get();
            return new ProjectCollection($projects);
        } catch (\Throwable $th) {
            return $this->errorResponse('Failed to fetch projects data!');
        }
    }
}
