<?php

namespace App\CustomerApp\Http\Controllers\Api\V1\Receipt;

use App\Api\Http\Controllers\Controller;
use App\CustomerApp\Http\Requests\Api\V1\Receipts\GetReceiptsRequest;
use App\CustomerApp\Http\Resources\Receipts\ReceiptCollection;
use App\Receipt;
use App\Traits\ApiResponse;

class ReceiptsController extends Controller
{
    use ApiResponse;

    public function index(GetReceiptsRequest $request)
    {
        try {
            $customer = auth()->user();
            $receipts = Receipt::with('getSalesData')->where('client_id', $customer->lead_id)->where('sale_id', $request->sale_id)->where('is_approved', 1)->paginate($request->limit);
            return new ReceiptCollection($receipts);
        } catch (\Throwable $th) {
            return $this->errorResponse('Failed to fetch payment receipts!');
        }
    }
}
