<?php

namespace App\CustomerApp\Http\Requests\Api\V1\Auth;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'username' => ['required', 'exists:customers,username'],
            'password' => ['required'],
            'device_id' => ['required'],
            'device_name' => ['required'],
            'device_type' => ['required'],
            'push_token' => ['required'],
        ];
    }
}
