<?php

namespace App\CustomerApp\Http\Resources\Customer;

use Illuminate\Http\Resources\Json\JsonResource;

class CustomerResource extends JsonResource
{
    private $token;
    public function __construct($resource, $token = null)
    {
        parent::__construct($resource);
        $this->token = $token;
    }

    public function toArray($request): array
    {
        return [
            'user_id' => $this->id,
            'name' => (string)$this->full_name,
            'residential_status' => (string) $this->residential_status,
            'phone' => (string)$this->mobile,
            'email' => (string)$this->email,
            'location' => (string)$this->location,
            'auth_token' => $this->token,
        ];
    }
}
