<?php

namespace App\CustomerApp\Http\Resources\Receipts;

use Illuminate\Http\Resources\Json\ResourceCollection;

class ReceiptCollection extends ResourceCollection
{
    public $collects = ReceiptResource::class;

    public function toArray($request): array
    {
        $totalAmountPaid = $this->collection->isNotEmpty() ? $this->collection->first()->getSalesData->total_paid_amount : 0;
        return [
            'status' => true,
            'message' => 'Payment Receipts',
            'data' => [
                'total_amount_paid' => number_format($totalAmountPaid, 2),
                'receipts' => $this->collection
            ],
        ];
    }
}
