<?php

namespace App\CustomerApp\Http\Resources\Receipts;

use Illuminate\Http\Resources\Json\JsonResource;

class ReceiptResource extends JsonResource
{


    public function toArray($request): array
    {
        return [
            'receipt_no' => $this->receipt_no,
            'cleared_date' => date('d-m-Y', strtotime($this->clearing_date)),
            'mode_of_payment' => $this->mode_of_payment,
            'amount' => number_format($this->amount, 2),
            'receipt_url' =>route('client-receipt.download', base64_encode($this->id))
        ];
    }
}
