<?php

use App\CustomerApp\Http\Controllers\Api\V1\Auth\GuestLoginController;
use App\CustomerApp\Http\Controllers\Api\V1\Auth\LoginController;
use App\CustomerApp\Http\Controllers\Api\V1\Auth\RegisterController;
use App\CustomerApp\Http\Controllers\Api\V1\ContactUs\ContactUsController;
use App\CustomerApp\Http\Controllers\Api\V1\Projects\ProjectsController;
use App\CustomerApp\Http\Controllers\Api\V1\Receipt\ReceiptsController;
use App\CustomerApp\Http\Controllers\Api\V1\SiteVisit\SiteVisitController;
use Illuminate\Support\Facades\Route;


Route::group(['prefix' => 'v1'], function () {

    Route::post('login', [LoginController::class, 'login']);
    Route::post('guest-login', [GuestLoginController::class, 'login']);
    Route::post('verify-otp', [GuestLoginController::class, 'verifyOtp']);
    Route::post('register', [RegisterController::class, 'register']);

    Route::group(['middleware' => 'auth:sanctum'], function () {
        Route::post('logout', [LoginController::class, 'logout']);
        Route::get('payment-receipts', [ReceiptsController::class, 'index']);
        Route::get('contact-us', [ContactUsController::class, 'index']);
        Route::get('projects-sitevisit', [ProjectsController::class, 'index']);

    });
});
