<?php

namespace App\Exports;

use App\Helpers\ActivityLog;
use App\DsrBooking;
use App\Lead;
use App\PriceList;
use App\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class BookingDsrExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
    use Exportable;

    protected $request;

    public function __construct($request,$s_projects,$s_branchs)
    {
        $this->request = $request;

        $this->s_projects = $s_projects;

        $this->s_branchs = $s_branchs;
    }

    public function query()
    {

       

        $data = DsrBooking::with('getSaleActivity','getDsrSplits')->where('transferred_pending', 0)->select('*');

        $activity_subject = auth()->user()->name . ' viewed Dsr booking export:';
        \ActivityLog::addToLog($activity_subject, 'crm');

        if (count($this->s_projects) > 0) {
             $data->whereIn('project_id', $this->s_projects);
        }

        if (count($this->s_branchs) > 0) {
            $data->whereIn('branch_id', $this->s_branchs);
        }

       

        if ($this->request->user_id) {
            $data->where(function ($query)  {
                $query->where('sales_person_id', $this->request->user_id)
                    ->orWhereHas('getDsrSplits', function ($q)  {
                        $q->where('user_id', $this->request->user_id);
                    });
            });
        }
        if ($this->request->file_added=='yes') {

            $data->whereNotNull('sale_id');

        }else if($this->request->file_added=='no'){

            $data->whereNull('sale_id');
        }

        // if ($this->request->team_leader) {

        //     $data->where('team_leader_id', $this->request->team_leader);
        // }

        if ($this->request->team_leader) {
            $data->where(function ($query) {
                $query->where('team_leader_id', $this->request->team_leader)
                    ->orWhereHas('getDsrSplits', function ($subquery) {
                        $subquery->where('team_leader_id', $this->request->team_leader)
                            ->where('status', 'AGREEMENTED');
                    });
            });
        }
        
        if($this->request->events){
            $data->where('event_id', $this->request->events);
        }
        
        

        if ($this->request->status) {

            $data->where('status', $this->request->status);
        }
        if ($this->request->quarter) {

            $data->where('quarter', $this->request->quarter);
        }


        // if ($this->request->from) {
        //     $data->where('booking_date', '>=', date('Y-m-d', strtotime($this->request->from)));
        // }

        // if ($this->request->to) {
        //     $data->where('booking_date', '<=', date('Y-m-d', strtotime($this->request->to)));
        // }
       
        if ($this->request->s_from) {
           
            if ($this->request->status=="BOOKING") {
                $data->where('booking_date', '>=', date('Y-m-d', strtotime($this->request->s_from)));
            } else if ($this->request->status=="AGREEMENTED") {
                $data->where('agreement_date', '>=', date('Y-m-d', strtotime($this->request->s_from)));
            }else{
                $data->where('created_at', '>=', date('Y-m-d', strtotime($this->request->s_from)));
            }
            
           
        }

        if ($this->request->s_to) {

            if ($this->request->status=="BOOKING") {
                $data->where('booking_date', '<=', date('Y-m-d', strtotime($this->request->s_to)));
            } else if ($this->request->status=="AGREEMENTED") {
                $data->where('agreement_date', '<=', date('Y-m-d', strtotime($this->request->s_to)));
            }else{
                $data->where('created_at', '<=', date('Y-m-d', strtotime($this->request->s_to)));
            }
           
        }
        return $data;
    }

    public function headings(): array
    {
        $set1 = [
            'Ref No',
            'Booking Date',
            'Customer Name',
            'Actual Name',
            'Branch',
            'Project',
            'Sales Person',
            'Team Leader',
            'Units',
            'Unit No',
            'Sale Value',
            'Car Parking',
            'Received Amount',
            'Status',
            'Agreemented'

        ];
       
        return  $set1;
    }

    public function map($lead): array
    {
        

        if ($lead->split>1) {
            if($lead->getDsrSplits->count()>1){
                $suser=[];
                foreach ($lead->getDsrSplits as $key => $getDsrSplit) {
                    $suser[$key] = $getDsrSplit->getUser->name;
                }
                
                $sales_persons =  join(' | ', $suser);
            }
            
        }else{
            if ($lead->sales_person_id != '') {

                $sales_person =  $lead->getUser->name;
            } else {
                $sales_person = '';
            }
            $sales_persons =  $sales_person;
        }

        if ($lead->unit_id != 0) {
            $price = PriceList::find($lead->unit_id);
            $price_list =  $price->ap_no;
        } else {
            $price_list = '';
        }


        if ($lead->split>1 && $this->request->user_id) {
            if($lead->getDsrSplits->count()>1){
                $amount =  $lead->getDsrSplits->where('user_id',$this->request->user_id)->first();
                $sale = $amount->amount ?? '';
                
            }
            
        }else{
           
            $sale = $lead->sale_value ?? '';
        }
       
        
        $set1 = [
            $lead->id,
            date('d-m-Y', strtotime($lead->booking_date)),
            $lead->customer_name,
            isset($lead->getSaleActivity) ? $lead->getSaleActivity->getLeads->enquirer_name : '',
            isset($lead->getBranch) ? $lead->getBranch->name : '',
            isset($lead->getProject) ? $lead->getProject->project_name : '',
            isset($sales_persons) ? $sales_persons:'',
            isset($lead->getTeamLeader) ? $lead->getTeamLeader->name : '',
            $lead->units,
            isset($price_list) ? $price_list:'',
            isset($sale) ? $sale:'',
            isset($lead->carparking_no) ? $lead->carparking_no : '',
            isset($lead->getSaleActivity->total_paid_amount) ? $lead->received_amount : '',
            $lead->status,
            isset($lead->agreement_date) ? $lead->agreement_date : '',
        ];
        return  $set1;
    }

    public function fields(): array
    {
        $set1 = [
            'id',
            'booking_date',
            'customer_name',
            'actual_name',
            'branch_id',
            'project_id',
            'sales_person_id',
            'team_leader_id',
            'units',
            'unit_id',
            'sale_value',
            'carparking_no',
            'received_amount',
            'status'
        ];
       
        return  $set1;
    }
}
