<?php

namespace App\Exports\Clients;

use App\Lead;
use Maatwebsite\Excel\Concerns\FromCollection;
use App\ProposalEmi;
use Carbon\Carbon;
use App\SalesActivity;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;

class CustomerVerificationExport implements FromCollection, WithHeadings
{

    use Exportable;
    protected $headerDateFrom;
    protected $headerDateTo;

    public function __construct($project, $unit)
    {
        $this->project = $project;
        $this->unit = $unit;

    }

    public function collection()
    {
        $rows = SalesActivity::with('getLeads', 'getProject', 'getProjectUnit', 'getSalesOwner',)
        ->whereIn('is_verified', [1, 2, 3, 4])
        ->whereNotIn('booking_status', ['hold', 'cancelled'])
        ->where(function ($query) {
            $query->whereNull('is_cancelled')->orWhere('is_cancelled', 'rejected');
        });
        
        if ($this->project) {

            $rows->where('project', $this->project);
        }

        if ($this->unit) {
            $rows->where('project_unit', $this->unit);
        }

        $data = $rows->get();

        $result = $data->map(function ($leads) {
            $customerStatus = '';
            if ($leads->customer_status == 0) {
                $customerStatus = 'Not verified';
            } elseif ($leads->customer_status == 1) {
                $customerStatus = 'Updated';
            } else {
                $customerStatus = 'Verified';
            }

            $sale = '';
            if ($leads->getFinalProposal) {
                if ($leads->getFinalProposal->sale_value > 0) {
                    $sale = $leads->getFinalProposal->sale_value;
                } elseif ($leads->getFinalProposal->grand_total > 0) {
                    $sale = $leads->getFinalProposal->grand_total;
                } else {
                    $sale = $leads->project_value ?? '';
                }
            } else {
                $sale = $leads->project_value ?? '';
            }

            return [
                'enquirer name' => $leads->getLeads->enquirer_name ?? '',
                'sale value' => $sale ?? '',
                'customer status' => $customerStatus,
                'amount received' => $leads->total_paid_amount ?? '',
            ];
        });
        
        
            return $result;
    }

    public function headings(): array
    {
        return [
            'Enquirer name',
            'Sale Value',
            'Customer Status',
            'Amount Received'
          
        ];
    }
}
