<?php

namespace App\Exports\Clients;

use App\ProposalEmi;
use App\SalesActivity;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Maatwebsite\Excel\Events\AfterSheet;

class PartnerClientsExport implements FromCollection, WithHeadings, WithStrictNullComparison, WithCustomStartCell, WithEvents, ShouldAutoSize
{
    use Exportable;
    protected $headerDateFrom;
    protected $headerDateTo;

    public function __construct($dateFrom, $dateTo, $project, $unit, $users)
    {


        $this->dateFrom = $dateFrom;
        $this->dateTo = $dateTo;
        $this->project = $project;
        $this->unit = $unit;


        $this->users = $users;

        $this->headerDateFrom = Carbon::parse($dateFrom)->format('d-m-Y');
        $this->headerDateTo = Carbon::parse($dateTo)->format('d-m-Y');
    }

    public function collection()
    {

        $rows = SalesActivity::with(['getLeads', 'getProject'])
            ->whereIn('is_verified', [1, 2, 3, 4])
            ->whereNotIn('booking_status', ['hold', 'cancelled'])
            ->where(function ($query) {
                $query->whereNull('is_cancelled')->orWhere('is_cancelled', 'rejected');
            })->orderBy('id', 'desc');

        if (count($this->users) > 0) {
            $rows = $rows->whereIn('sales_owner', $this->users);
        }

        if ($this->project) {
            $rows->where('project', $this->project);
        }

        if ($this->unit) {
            $rows->where('project_unit', $this->unit);
        }

        if ($this->dateFrom) {
            $rows->where('sales_date', '>=', date('Y-m-d', strtotime($this->dateFrom)));
        }

        if ($this->dateTo) {
            $rows->where('sales_date', '<=', date('Y-m-d', strtotime($this->dateTo)));
        }

        $data = $rows->get();
        $result = [];
        foreach ($data as $key => $row) {
            $result[] = [
                'Serial Number' => $key + 1,
                'Client Name' => $row->getLeads->enquirer_name ?? '',
                'Project' => $row->getProject->project_name ?? '',
                'PAN Number' =>   $row->getLeads->pan_no ?? '',
                'Address' => $row->getLeads->address . ($row->getLeads->pin ? ' ,PIN : ' . $row->getLeads->pin : ''),
            ];
        }

        $result = collect($result);

        return $result;
    }

    public function startCell(): string
    {
        return 'A2';
    }


    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                /** @var Sheet $sheet */
                $sheet = $event->sheet;

                $sheet->mergeCells('A1:E1');
                $sheet->getColumnDimension('D')->setAutoSize(true);

                $sheet->setCellValue('A1', 'CLIENT DETAILS');
                $default_font_style = [
                    'font' => ['name' => 'Arial', 'size' => 12, 'bold' => true],
                ];
                $header_font = [
                    'font' => ['name' => 'Arial', 'size' => 10, 'bold' => true],
                ];

                $styleArray = [
                    'alignment' => [
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ],
                ];


                $cellRange = 'A1:E1'; // All headers
                $event->sheet->getDelegate()->getStyle($cellRange)->applyFromArray($styleArray);
                $event->sheet->getStyle('A1:E1')->applyFromArray($default_font_style);
                $event->sheet->getStyle('A2:E2')->applyFromArray($header_font);
            },
        ];
    }

    public function headings(): array
    {
        return [
            [
                'SL.NO',
                'CLIENT NAME',
                'PROJECT',
                'PAN NO',
                'ADDRESS',
            ],
        ];
    }
}
