<?php

namespace App\Exports;

use App\ProposalEmi;
use Carbon\Carbon;
use App\SalesActivity;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;

class ExportCancelledSales implements FromCollection, WithHeadings, WithStrictNullComparison, WithCustomStartCell, WithEvents, ShouldAutoSize
{
    use Exportable;
    protected $headerDateFrom;
    protected $headerDateTo;

    public function __construct($dateFrom, $dateTo, $project, $unit,$s_user,$branch)
    {


        $this->dateFrom = $dateFrom;
        $this->dateTo = $dateTo;
        $this->project = $project;
        $this->unit = $unit;

        $this->s_user = $s_user;
        $this->branch = $branch;

        $this->headerDateFrom = Carbon::parse($dateFrom)->format('d-m-Y');
        $this->headerDateTo = Carbon::parse($dateTo)->format('d-m-Y');
    }

    public function collection()
    {
        $rows = SalesActivity::with(['getLeads', 'getProject', 'getProjectUnit', 'getSalesOwner', 'getLeads.getCoApplicants', 'getLeads.getSource', 'getLeads.getLeadCategory', 'getLeads.getLeadStage'])
        ->where(function ($q) {
            $q->where('booking_status', 'cancelled')->where('is_cancelled', 'approved');
        });

        if (count($this->s_user) > 0) {
            $rows = $rows->whereIn('sales_owner', $this->s_user);
        }

        if ($this->project) {
            
            $rows->where('project', $this->project);
           
        }

        if ($this->branch) {
            
            $rows->where('branch_id', $this->branch);
           
        }

        if ($this->unit) {
            $rows->where('project_unit', $this->unit);
        }

        if ($this->dateFrom) {
            $rows->where('sales_date', '>=', date('Y-m-d', strtotime($this->dateFrom)));
        }

        if ($this->dateTo) {
            $rows->where('sales_date', '<=', date('Y-m-d', strtotime($this->dateTo)));
        }

        $data = $rows->get();

        $result = [];
        foreach ($data as $key => $row) {
            $units = '';
            if($row->getProjectUnit){
                $units = $row->getProjectUnit ? $row->getProjectUnit->ap_no : '';
            }
            else{
                $units = $row->no_of_unit ? $row->no_of_unit: '';

            }

            if(auth()->user()->hasRole('super-admin')){
            $result[] = [
                'Client Name' => $row->getLeads->enquirer_name,
                'Project' => $row->getProject->project_name,
                'Unit' =>   $units,
                'File Number'=> $row->sale_ref_number ?? '',
                'Email' => $row->getLeads->email ??'',
                'Mobile No.' => $row->getLeads->phone_code . ' ' . $row->getLeads->mobile,
                'Gender' => $row->getLeads->gender,
                'Dob' => $row->getLeads->dob,
                'Address' => $row->getLeads->address,
                'Location' => $row->getLeads->location,
                'Pin' => $row->getLeads->pin,
                'PAN No' => $row->getLeads->pan_no,
                'State' => $row->getLeads->state,
                'Post' => $row->getLeads->post,
                'Village' => $row->getLeads->village,
                'Taluk' => $row->getLeads->taluk,
                'Desom' => $row->getLeads->desom,
                'Source' => $row->getLeads->getSource->name ?? '',
                'Sale Date' => Carbon::parse($row->sales_date)->format('d-m-Y'),
                'Sales Person' => $row->getSalesOwner->name,
                'Payment Progress' => sprintf('%0.2f', $row->total_paid_amount / $row->project_value * 100) . ' %',
                'sale value' => $row->project_value ?? '',
                'Emi Amount' => ProposalEmi::where('proposal_id', $row->proposal_id)->value('emi_amount'),

            ];
        }else{
            $result[] = [
                'Client Name' => $row->getLeads->enquirer_name,
                'Project' => $row->getProject->project_name,
                'Unit' =>   $units,
                'File Number'=> $row->sale_ref_number ?? '',
                // 'Gender' => $row->getLeads->gender,
                // 'Dob' => $row->getLeads->dob,
                // 'Address' => $row->getLeads->address,
                // 'Location' => $row->getLeads->location,
                // 'Pin' => $row->getLeads->pin,
                // 'PAN No' => $row->getLeads->pan_no,
                // 'State' => $row->getLeads->state,
                // 'Post' => $row->getLeads->post,
                // 'Village' => $row->getLeads->village,
                // 'Taluk' => $row->getLeads->taluk,
                // 'Desom' => $row->getLeads->desom,
                'Source' => $row->getLeads->getSource->name ?? '',
                'Sale Date' => Carbon::parse($row->sales_date)->format('d-m-Y'),
                'Sales Person' => $row->getSalesOwner->name,
                'Payment Progress' => sprintf('%0.2f', $row->total_paid_amount / $row->project_value * 100) . ' %',
                'sale value' => $row->project_value ?? '',
                'Emi Amount' => ProposalEmi::where('proposal_id', $row->proposal_id)->value('emi_amount'),

            ];
        }
    }

        $result = collect($result);

        return $result;
    }

    public function startCell(): string
    {
        return 'A2';
    }


    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                /** @var Sheet $sheet */
                $sheet = $event->sheet;

                $sheet->mergeCells('A1:T1');
                // $sheet->setCellValue('A1', 'Lead Status From ' . $this->headerDateFrom . ' To ' . $this->headerDateTo);

                $sheet->setCellValue('A1', 'Cancelled Sales List');

                $default_font_style = [
                    'font' => ['name' => 'Arial', 'size' => 15],
                ];
                $header_font = [
                    'font' => ['name' => 'Arial', 'size' => 11],
                ];

                $styleArray = [
                    'alignment' => [
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ],
                ];

                $cellRange = 'A1:T1'; // All headers
                $event->sheet->getDelegate()->getStyle($cellRange)->applyFromArray($styleArray);
                // $event->sheet->getParent()->getDefaultStyle()->applyFromArray($default_font_style);
                $event->sheet->getStyle('A1:U1')->applyFromArray($default_font_style);
                $event->sheet->getStyle('A2:U2')->applyFromArray($header_font);
            },
        ];
    }

    public function headings(): array
    {
        if(auth()->user()->hasRole('super-admin')){
        return [
            [
                'Client Name',
                'Project',
                'Unit / No Of Shares',
                'File Number',
                'Email',
                'Mobile No.' ,
                'Gender',
                'DOB',
                'Address',
                'Location',
                'Pin',
                'PAN No',
                'State',
                'Post',
                'Vilage',
                'Taluk',
                'Desom',
                'Source',
                'Sale Date',
                'Sales Person',
                'Payment Progress',
                'sale value',
                'Emi Amount'
                

            ],
        ];
    }else{
        return [
            [
                'Client Name',
                'Project',
                'Unit / No Of Shares',
                'File Number',
                // 'Gender',
                // 'DOB',
                // 'Address',
                // 'Location',
                // 'Pin',
                // 'PAN No',
                // 'State',
                // 'Post',
                // 'Vilage',
                // 'Taluk',
                // 'Desom',
                'Source',
                'Sale Date',
                'Sales Person',
                'Payment Progress',
                'sale value',
                'Emi Amount'
                

            ],
        ];
    }
}
}
