<?php

namespace App\Exports;

use App\Lead;
use Carbon\Carbon;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;

class ExportSourceStageLeads implements FromCollection, WithHeadings, WithStrictNullComparison, WithCustomStartCell, WithEvents, ShouldAutoSize
{
    use Exportable;
    protected $dateFrom;
    protected $dateTo;
    protected $headerDateFrom;
    protected $headerDateTo;

    public function __construct($dateFrom, $dateTo)
    {
        $this->dateFrom = $dateFrom;
        $this->dateTo = $dateTo;
        $this->headerDateFrom = Carbon::parse($dateFrom)->format('d-m-Y');
        $this->headerDateTo = Carbon::parse($dateTo)->format('d-m-Y');
    }

    public function collection()
    {

        $totalLeads = Lead::whereBetween('created_at', [$this->dateFrom, $this->dateTo])->has('getSource')->get();

        $leads = Lead::select('source', 'enquirer_name', 'lead_category', 'lead_stage_id', 'lost_lead_approval', 'is_verified', 'created_at')
            ->with('getSource')
            // ->orderBy('source')
            ->whereBetween('created_at', [$this->dateFrom, $this->dateTo])
            ->has('getSource')
            ->get()
            ->groupBy('source');
        $result = [];
        foreach ($leads as $key => $lead) {
            $result[] = [
                'campaign' => $lead[0]->getSource ? $lead[0]->getSource->name : '',
                'total_lead' => $lead->count(),

                'contact' => $lead->where('lead_stage_id', '1')->count(),
                'prospect' => $lead->where('lead_stage_id', '2')->count(),
                'site_visit' => $lead->where('lead_stage_id', '3')->count(),
                'in_discussion' => $lead->where('lead_stage_id', '4')->count(),
                'negotiation' => $lead->where('lead_stage_id', '5')->count(),
                'not_interested' => $lead->where('lead_stage_id', '6')->count(),
                'customer' => $lead->where('lead_stage_id', '7')->count(),
                'invalid' => $lead->where('lead_stage_id', '8')->count(),
                'not_answering' => $lead->where('lead_stage_id', '9')->count(),
             

            ];
        }


        array_push($result, [
            'campaign' => 'Total',
            'total_lead' => $totalLeads->count(),

            'contact' => $totalLeads->where('lead_stage_id', '1')->count(),
            'prospect' => $totalLeads->where('lead_stage_id', '2')->count(),
            'site_visit' => $totalLeads->where('lead_stage_id', '3')->count(),
            'in_discussion' => $totalLeads->where('lead_stage_id', '4')->count(),
            'negotiation' => $totalLeads->where('lead_stage_id', '5')->count(),
            'not_interested' => $totalLeads->where('lead_stage_id', '6')->count(),
            'customer' => $totalLeads->where('lead_stage_id', '7')->count(),
            'invalid' => $totalLeads->where('lead_stage_id', '8')->count(),
            'not_answering' => $totalLeads->where('lead_stage_id', '9')->count(),
      


        ]);


        return collect($result);
    }

    public function startCell(): string
    {
        return 'A2';
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                /** @var Sheet $sheet */
                $sheet = $event->sheet;

                $sheet->mergeCells('A1:L1');
                $sheet->setCellValue('A1', 'Lead Status From ' . $this->headerDateFrom . ' To ' . $this->headerDateTo);

                $default_font_style = [
                    'font' => ['name' => 'Arial', 'size' => 15],
                ];
                $header_font = [
                    'font' => ['name' => 'Arial', 'size' => 11],
                ];

                $styleArray = [
                    'alignment' => [
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ],
                ];

                $cellRange = 'A1:Q1'; // All headers
                $event->sheet->getDelegate()->getStyle($cellRange)->applyFromArray($styleArray);
                // $event->sheet->getParent()->getDefaultStyle()->applyFromArray($default_font_style);
                $event->sheet->getStyle('A1:L1')->applyFromArray($default_font_style);
                $event->sheet->getStyle('A2:L2')->applyFromArray($header_font);
            },
        ];
    }

    public function headings(): array
    {
        return [
            [
                'Campaign',
                'Total Lead',
                'New Leads',


                'Contact',
                'Prospect',
                'Site Visit',
                'In Discussion',
                'Negotiation',
                'Not Interested',
                'Customer',
                'Invalid',
                'Not Answering',
               
            ],
        ];
    }
}
