<?php

namespace App\Exports;

use App\Lead;
use App\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class LeadsExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
    use Exportable;

    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function query()
    {


        $userPermissions = auth()
            ->user()
            ->userPermissions();

        $userRoles = auth()
            ->user()
            ->userRoles();



        $authUser = auth()->user(); //\Auth::user()
        // $all_reporting_users_id_array = [];

        // if (!Auth::user()->hasRole('admin') && !Auth::user()->hasRole('super-admin') && !Auth::user()->hasRole('sales-head') && !Auth::user()->hasRole('ceo')) { // Except superadmin and management
        //     $all_reporting_users_id_array = Auth::user()->getAllReportingUsersIds();

        //     array_push($all_reporting_users_id_array, Auth::user()->id);

        //     // if ($this->request->s_sales_person && count($this->request->s_sales_person) == 0) {
        //     //     $rows = $rows->whereIn('attended_by', $all_reporting_users_id_array);
        //     // }
        // }

        $active_lost_lead = $this->request->active_lost_lead ? $this->request->active_lost_lead : 'active';
        $project = $this->request->s_project ?? '';
        $salesPerson = $this->request->s_sales_person ?? '';
        $leadSource = $this->request->s_source ?? '';
        $leadStage = $this->request->s_stage;
        $leadCategory = $this->request->s_category ?? "";
        $fromDate = $this->request->s_from ?? '';
        $toDate = $this->request->s_to ?? '';
        $branchUser = $this->request->branch_user ??'';

        $user_id = $this->request->user_id;
        $project_type_id = $this->request->project_type_id;

        $teamLeader = intval($this->request->s_team_leader);

        $phoneCodeFilter = $this->request->phone_code_filter;



        if ($this->request->s_from) {

            $fromDate = Carbon::parse($this->request->s_from)->startOfDay()->format('Y-m-d H:i:s');
        }

        if ($this->request->s_to) {
            $toDate = Carbon::parse($this->request->s_to)->endOfDay()->format('Y-m-d H:i:s');;
        }

        $rows = Lead::query()
            ->with('getSource', 'getLeadStage', 'getLeadCategory', 'getProjectType', 'getBudget', 'getPreferredProject', 'getAttendedBy')
            ->where('is_ceo_verified', '1')
            // ->when(empty($salesPerson), function ($q) use ($all_reporting_users_id_array) {
            //     $q->whereIn('attended_by', $all_reporting_users_id_array);
            // })
            ->when($project, function ($q, $project) {
                return $q->whereIn('preferred_project', $project);
            })

            ->when($salesPerson, function ($q, $salesPerson) {
                return $q->whereIn('attended_by', $salesPerson);
            })
            ->when($leadSource, function ($q, $leadSource) {
                return $q->whereIn('source', $leadSource);
            })
            ->when($leadStage, function ($q, $leadStage) {
                return $q->whereIn('lead_stage_id', $leadStage);
            })
            ->when($leadCategory, function ($q, $leadCategory) {
                return $q->whereIn('lead_category', $leadCategory);
            })
            ->when($branchUser , function ($q, $branchUser) {
                $q->where('created_by', $branchUser)->orWhere('attended_by', $branchUser);
            })
            ->when($fromDate, function ($q, $fromDate) {
                return $q->whereDate('created_at', '>=', $fromDate);
            })
            ->when($toDate, function ($q, $toDate) {
                return $q->whereDate('created_at', '<=', $toDate);
            })
            ->when($phoneCodeFilter, function ($q, $phoneCodeFilter) {
                return $q->where('phone_code', $phoneCodeFilter);
            })->when($teamLeader, function ($q, $teamLeader) {
                $teamLeaderObj = User::find($teamLeader);
                $leadersAndUsers = $teamLeaderObj->getAllReportingUsersIds();
                array_push($leadersAndUsers, $teamLeader);
                return $q->whereIn('attended_by', $leadersAndUsers);
            });

            if ($this->request->customer=='yes') {

                $rows =  $rows->where('lead_stage_id',7);
    
            }

        if ('active' == $active_lost_lead) {
            $rows = $rows->where(function ($query) {
                $query->whereNotIn('lead_stage_id', [6, 7, 8])->orWhereNull('lead_stage_id'); // 6 not interested
            });

            // $rows = $rows->where('lead_stage_id', '<>',6)->orWhereNull('lead_stage_id');// 6 not interested
        } elseif ('lost' == $active_lost_lead) {
            $rows = $rows->where(function ($query) {
                $query->where('lead_stage_id', '=', 6)->where('lead_stage_id', '<>', 7)->orWhere('lead_stage_id', '=', 8);
            });
            $rows = $rows->where(function ($query) {
                $query->where('lost_lead_approval', 1); // 6 not interested,8 invalid
            });
        } elseif ('lost-pending' == $active_lost_lead) {
            $rows = $rows->where(function ($query) {
                $query->where('lead_stage_id', '=', 6)->where('lead_stage_id', '<>', 7)->orWhere('lead_stage_id', '=', 8);
            });
            $rows = $rows->where(function ($query) {
                $query->where('lost_lead_approval', 0)->orWhereNull('lost_lead_approval'); // 6 not interested,8 invalid
            });
        } elseif ('duplicate' == $active_lost_lead) {
            $rows = $rows->where('duplicate_entry', 'yes')->where(function ($q) {
                $q->where('sales_head_approval', 0)
                    ->orWhereNull('sales_head_approval');
            })
                ->where(function ($q) {
                    $q->where('lead_stage_id', '<>', 7)
                        ->orWhereNull('lead_stage_id');
                })->whereNotNull('duplicate_request_at');
        } elseif ('customer' == $active_lost_lead) {
            $rows = $rows->where(function ($query) {
                $query->where('lead_stage_id', 7)->where('sale_status', 'yes');
            });
        } elseif ('all' == $active_lost_lead) {
     
        }

        // ->when($active_lost_lead == 'active', function ($q) {
        //     return $q->where(function ($query) {
        //         $query->whereNotIn('lead_stage_id', [6, 7])
        //             ->orWhereNull('lead_stage_id'); // 6 not interested
        //     });
        // })
        // ->when($active_lost_lead == 'lost', function ($q) {
        //     return $q->whereIn('lead_stage_id', [6, 8])
        //         ->where('lost_lead_approval', 1);
        // })
        // ->when($active_lost_lead == 'duplicate', function ($q) {
        //     return $q->where('duplicate_entry', 'yes')
        //         ->where(function ($q) {
        //             $q->where('lead_stage_id', '<>', 7)
        //                 ->orWhereNull('lead_stage_id');
        //         })
        //         ->where('sales_head_approval', '!=', 1);
        // })
        // ->when($active_lost_lead == 'lost-pending', function ($q) {
        //     return $q->whereIn('lead_stage_id', [6, 8])
        //         ->where(function ($query) {
        //             $query->where('lost_lead_approval', 0)
        //                 ->orWhereNull('lost_lead_approval');
        //         });
        // })
        // ->when($active_lost_lead == 'customer', function ($q) {
        //     return $q->where('sale_status', 'yes');
        // })
        // ->when($active_lost_lead != 'customer', function ($q) {
        //     return $q->where('sale_status', 'no');
        // });

        if ($user_id) {


            $rows = $rows->where(function ($query) use ($user_id) {
                $query->where('created_by', $user_id)->orWhere('attended_by', $user_id);
            });
        }
        if ($project_type_id) {

            if ($project_type_id == 'other') {
                $rows = $rows->whereNull('project_type');
            } else {
                $rows = $rows->where('project_type', $project_type_id);
            }
        }

        if (!$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin')) { //Except superadmin and admin
            $all_reporting_users_id_array = $authUser->getAllReportingUsersIds();
            array_push($all_reporting_users_id_array, $authUser->id);


            if (empty($request->s_sales_person)) {

                if (empty($authUser->reporting_to)) { //manu
                    $rows = $rows->where(function ($query) use ($authUser) {
                        $query->whereNull('attended_by')->where('created_by', $authUser->id); // manu to see imported his lead case
                    })->orWhere('source', 1)->orWhere('source', 12)
                        ->where('is_attended', 1);
                } else {


                    // dd($all_reporting_users_id_array);
                    if ($userRoles->contains('slug', 'team-leader')) {


                        $rows = $rows->whereIn('attended_by', $all_reporting_users_id_array);
                    }
                    elseif ($userRoles->contains('slug', 'sales-head')) {
                        $branchUserIds = User::where('branch_id', auth()->user()->branch_id)->get()->pluck('id');

                        $rows = $rows->whereIn('attended_by', $branchUserIds);
                    } else {
                        $rows = $rows->whereIn('attended_by', $all_reporting_users_id_array)->where('is_attended', 1);
                    }
                }
            }
        }


        if (auth()->user()->hasRole('executive')) {
            $rows->where('is_attended', 1);
        }
        return $rows->orderBy('created_at', 'desc');
    }

    public function headings(): array
    {
        $set1 = [
            'EnquirerName',
            'Email',
            'Mobile',
            'AltMobile',
            'Source',
            'Location',
           'Customer Status',
            'Stage',
            'ProjectType',
            'PreferredProject',
            'Budget',
            'Remarks',
            'AttendedBy',
            'CreatedBy',

            'Date',
            'Remark'
        ];
        $set2 = [
            'EnquirerName',
            'Email',
            'Mobile',
            'AltMobile',
            'Source',
            'Location',
            'Customer Status',
            'Stage',
            'Category',
            'ProjectType',
            'PreferredProject',
            'Budget',
            'LeadStage %',
            'AttendedBy',
            'CreatedBy',

            'Date',
            'Remark',
        ];
        if ($this->request->active_lost_lead &&  $this->request->active_lost_lead == 'lost') {
            return  $set1;
        }
        return  $set2;
    }

    public function map($lead): array
    {
        if($lead->lead_stage_id == 7){
            $customer_status = 'Yes';
           
        }else{
            $customer_status='No';
            
        }
        
        $set1 = [
            $lead->enquirer_name,
            $lead->email,
            $lead->phone_code . ' ' . $lead->mobile,


            $lead->alt_mobile,
            isset($lead->getSource) ? $lead->getSource->name : '',
            $lead->location ?? '',
            $customer_status,
            isset($lead->getLeadStage) ? $lead->getLeadStage->name : '',
            isset($lead->getLeadCategory) ? $lead->getLeadCategory->name : '',
            isset($lead->getProjectType) ? $lead->getProjectType->name : '',
            isset($lead->getPreferredProject) ? $lead->getPreferredProject->project_name : '',
            isset($lead->getBudget) ? $lead->getBudget->name : '',
            $lead->remarks,
            isset($lead->getAttendedBy) ? $lead->getAttendedBy->name : '',
            isset($lead->getCreatedBy) ? $lead->getCreatedBy->name : 'Admin',

            date('d-m-Y', strtotime($lead->created_at)),
            $lead->remarks,
        ];
        $set2 = [
            $lead->enquirer_name,
            $lead->email,
            $lead->phone_code . ' ' . $lead->mobile,


            $lead->alt_mobile,
            isset($lead->getSource) ? $lead->getSource->name : '',
            $lead->location ?? '',
            $customer_status,
            isset($lead->getLeadStage) ? $lead->getLeadStage->name : '',
            isset($lead->getLeadCategory) ? $lead->getLeadCategory->name : '',
            isset($lead->getProjectType) ? $lead->getProjectType->name : '',
            isset($lead->getPreferredProject) ? $lead->getPreferredProject->project_name : '',
            isset($lead->getBudget) ? $lead->getBudget->name : '',
            isset($lead->getLeadStage) ? $lead->getLeadStage->percentage . ' % ' : 0,
            isset($lead->getAttendedBy) ? $lead->getAttendedBy->name : '',
            isset($lead->getCreatedBy) ? $lead->getCreatedBy->name : 'Admin',

            date('d-m-Y', strtotime($lead->created_at)),
            $lead->remarks,
        ];
        if ($this->request->active_lost_lead &&  $this->request->active_lost_lead == 'lost') {
            return  $set1;
        }
        return  $set2;
    }

    public function fields(): array
    {
        $set1 = [
            'enquirer_name',
            'email',
            'mobile',
            'alt_mobile',
            'source',
            'location',
            'lead_stage',
            'customer_status',
            'lead_category',
            'project_type',
            'pref_project',
            'budget',
            'remarks',
            'attended_by',
            'created_by',
            'newDate',
            'premarks'
        ];
        $set2 = [
            'enquirer_name',
            'email',
            'mobile',
            'alt_mobile',
            'source',
            'lead_stage',
            'customer_status',
            'location',
            'lead_category',
            'project_type',
            'pref_project',
            'budget',
            'remarks',
            'attended_by',
            'created_by',
            'newDate',
            'premarks',
        ];
        if ($this->request->active_lost_lead &&  $this->request->active_lost_lead == 'lost') {
            return  $set1;
        }
        return  $set2;
    }
}
