<?php

namespace App\Exports;

use App\Lead;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ReplicatedLeadExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $user = 156;
        $data = Lead::whereIn('mobile', function ($query) use ($user) {
                $query->select('mobile')
                    ->from('leads')
                    ->join('call_logs', 'leads.id', '=', 'call_logs.lead_id')
                    ->where('call_logs.user_id', $user);
            })
            ->with(['getCreatedBy', 'getSource']) 
            ->get();

           $result = $data->map(function ($leads){
                return [
                    'enquirer name' => $leads->enquirer_name ?? '',
                    'source' => $leads->getSource->name ?? '',
                    'mobile' => $leads->mobile ?? '',
                    'lead date' => $leads->lead_date ?? '',
                    'created by' => $leads->getCreatedBy->name ?? ''
                ];
           });
        
            return $result;
    }

    public function headings(): array
    {
        return [
            'Enquirer name',
            'Source',
            'Mobile',
            'Lead Date',
            'Sales Person'
        ];
    }
}
