<?php

namespace App\Exports\Reports;

use App\SalesActivity;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Maatwebsite\Excel\Events\AfterSheet;

class ExportIndividualSalesReport implements FromCollection, WithHeadings, WithStrictNullComparison, WithCustomStartCell, WithEvents, ShouldAutoSize
{
    public function __construct($dateFrom, $dateTo, $project, $unit, $salesPerson, $agreementMouStatus, $llpDeedStatus)
    {


        $this->dateFrom = $dateFrom;
        $this->dateTo = $dateTo;
        $this->project = $project;
        $this->unit = $unit;
        $this->salesPerson = $salesPerson;
        $this->agreementMouStatus = $agreementMouStatus;
        $this->llpDeedStatus = $llpDeedStatus;
    }

    public function collection()
    {



        $data = SalesActivity::with(
            'getLeads',
            'getProject',
            'getProjectUnit',
            'getSalesOwner',
            'saleDocuments'
        )
            ->whereIn('is_verified', [1, 2, 3])
            ->whereNotIn('booking_status', ['hold', 'cancelled'])
            ->where(function ($query) {
                $query->whereNull('is_cancelled')
                    ->orWhere('is_cancelled', 'rejected');
            })
            ->when($this->project, function ($q) {
                $q->where('project', $this->project);
            })
            ->when($this->unit, function ($q) {
                $q->where('project_unit', $this->unit);
            })
            ->when($this->salesPerson, function ($q) {
                $q->where('sales_owner', $this->salesPerson);
            })
            ->when($this->agreementMouStatus === 'completed', function ($q) {
                $q->whereHas('saleDocuments', function ($q) {
                    $q->whereIn('type', ['agreement', 'mou'])->where('status', 'completed');
                });
            })
            ->when($this->agreementMouStatus === 'pending', function ($q) {
                $q->whereDoesntHave('saleDocuments')
                    ->orWhereHas('saleDocuments', function ($query) {
                        $query->whereIn('type', ['agreement', 'mou'])->where('status', 'pending');
                    });
            })
            ->when($this->llpDeedStatus === 'completed', function ($q) {
                $q->whereHas('saleDocuments', function ($q) {
                    $q->whereIn('type', ['deed'])->where('status', 'completed');
                });
            })
            ->when($this->llpDeedStatus === 'pending', function ($q) {
                $q->whereDoesntHave('saleDocuments')
                    ->orWhereHas('saleDocuments', function ($query) {
                        $query->whereIn('type', ['deed'])->where('status', 'pending');
                    });
            })
            ->when($this->dateFrom, function ($q) {
                return $q->whereDate('sales_date', '>=', $this->dateFrom);
            })
            ->when($this->dateTo, function ($q) {
                return $q->whereDate('sales_date', '<=', $this->dateTo);
            })
            ->get();

        $result = [];
        foreach ($data as $key => $row) {
            $agreementMouDoc = false;
            if ($row->saleDocuments) {
                $agreementMouDoc = $row->saleDocuments->whereIn('type', ['agreement', 'mou'])->where('status', 'completed')->first();
            }

            $agreementDeed = false;
            if ($row->saleDocuments) {

                $agreementDeed = $row->saleDocuments->whereIn('type', ['deed'])->where('status', 'completed')->first();
            }

            $result[] = [
                'Unit No./Ref.No.' => $row->getProjectUnit ? $row->getProjectUnit->ap_no : $row->sale_ref_number,
                'Name of Customer' => $row->getLeads ? $row->getLeads->enquirer_name : '',
                'Project Name' => $row->getProject ? $row->getProject->project_name : '',
                'Sales Person' => $row->getSalesOwner ? $row->getSalesOwner->name : '',
                'Sale Value' => $row->project_value,
                'Amount Received' => $row->total_paid_amount,
                'Balance' => $row->project_value - $row->total_paid_amount,
                'Agreement/MOU Status' => $agreementMouDoc ? 'Completed' : 'Pending',
                'Document 1' => $agreementMouDoc ? '=HYPERLINK("' . asset('uploads/' . $agreementMouDoc->file) . '")' : '',
                'LLP/Deed Status' => $agreementDeed ? 'Completed' : 'Pending',
                'Document 2' => $agreementDeed ? '=HYPERLINK("' . asset('uploads/' . $agreementDeed->file) . '")' : '',

            ];
        }

        $result = collect($result);

        return $result;
    }
    public function startCell(): string
    {
        return 'A2';
    }
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                /** @var Sheet $sheet */
                $sheet = $event->sheet;

                $sheet->mergeCells('A1:K1');
                // $sheet->setCellValue('A1', 'Lead Status From ' . $this->headerDateFrom . ' To ' . $this->headerDateTo);

                $sheet->setCellValue('A1', 'Sales Report');

                $default_font_style = [
                    'font' => ['name' => 'Arial', 'size' => 15],
                ];
                $header_font = [
                    'font' => ['name' => 'Arial', 'size' => 11],
                ];

                $styleArray = [
                    'alignment' => [
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ],
                ];

                $cellRange = 'A1:I1'; // All headers
                $event->sheet->getDelegate()->getStyle($cellRange)->applyFromArray($styleArray);
                // $event->sheet->getParent()->getDefaultStyle()->applyFromArray($default_font_style);
                $event->sheet->getStyle('A1:I1')->applyFromArray($default_font_style);
                $event->sheet->getStyle('A2:I2')->applyFromArray($header_font);
            },
        ];
    }

    public function headings(): array
    {
        return [
            [
                'Unit No./Ref.No.',
                'Name of Customer',
                'Project Name',
                'Sales Person',
                'Sale Value',
                'Amount Received',
                'Balance',
                'Agreement/MOU Status',
                'Document',
                'LLP/Deed Status',
                'Document',


            ],
        ];
    }
}
