<?php

namespace App\Exports\Statements;

use App\SalesActivity;
use Illuminate\Support\Facades\Redirect;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;

class ProjectWiseStatementExport implements FromCollection, WithHeadings, WithStrictNullComparison, WithCustomStartCell, WithEvents, ShouldAutoSize
{
    use Exportable;

    public function __construct($dateFrom, $dateTo, $project, $sale_owner, $branchId)
    {



        $this->dateFrom = $dateFrom;
        $this->dateTo = $dateTo;
        $this->project = $project;
        $this->sale_owner = $sale_owner;
        $this->branchId = $branchId;


        // $this->headerDateFrom = Carbon::parse($dateFrom)->format('d-m-Y');
        // $this->headerDateTo = Carbon::parse($dateTo)->format('d-m-Y');
    }

    public function collection()
    {

        $rows = SalesActivity::with('getLeads', 'getProject', 'getProjectUnit', 'getSalesOwner')
            ->whereIn('is_verified', [1, 2, 3, 4])
            ->when($this->project, function ($q, $project) {
                $q->where('project', $project);
            })
            ->when($this->sale_owner, function ($q, $sale_owner) {
                $q->where('sales_owner', $sale_owner);
            })
            ->when($this->dateFrom, function ($q, $dateFrom) {
                return $q->whereDate('sales_date', '>=', date('Y-m-d', strtotime($dateFrom)));
            })
            ->when($this->dateTo, function ($q, $dateTo) {
                return $q->whereDate('sales_date', '<=', date('Y-m-d', strtotime($dateTo)));
            })
            ->when($this->branchId, function ($q) {
                $q->whereHas('getSalesOwner', function ($q) {
                    $q->where('branch_id', $this->branchId);
                });
            })
            ->orderBy('id', 'desc')->get();






        $result = [];
        foreach ($rows as $key => $row) {
            $result[] = [
                'project' => $row->getProject ? $row->getProject->project_name : '',
                'unit' => $row->getProjectUnit ? $row->getProjectUnit->ap_no : '',
                'client' => $row->getLeads ? $row->getLeads->enquirer_name : '',
                'sales_person' => $row->getSalesOwner ? $row->getSalesOwner->name : '',
                'project_value' => $row->project_value,
                'total_amount_received' => $row->total_paid_amount,
                'balance' => $row->project_value - $row->total_paid_amount,

            ];
        }

        $totalProjectValue = $rows->sum('project_value');
        $totalAmountReceived = $rows->sum('total_paid_amount');
        $totalBalance = $totalProjectValue - $totalAmountReceived;


        array_push($result, [

            ['project' => ''],
            [
                'project' => '',
                'unit' => '',
                'client' => '',
                'sales_person' => 'TOTAL',
                'total_project_value' => $totalProjectValue,
                'total_amount_received' => $totalAmountReceived,
                'balance' => $totalBalance,
            ],





        ]);
        $result = collect($result);

        // if ($result->isEmpty()) {
        // }

        return $result;
    }

    public function startCell(): string
    {
        return 'A2';
    }


    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                /** @var Sheet $sheet */
                $sheet = $event->sheet;

                $sheet->mergeCells('A1:G1');
                // $sheet->setCellValue('A1', 'Lead Status From ' . $this->headerDateFrom . ' To ' . $this->headerDateTo);

                $sheet->setCellValue('A1', 'Project Wise Mini Statement');

                $default_font_style = [
                    'font' => ['name' => 'Arial', 'size' => 14, 'bold' => true],
                ];
                $header_font = [
                    'font' => ['name' => 'Arial', 'size' => 11, 'bold' => true],
                ];

                $styleArray = [
                    'alignment' => [
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ],
                ];

                $cellRange = 'A1:G1'; // All headers
                $event->sheet->getDelegate()->getStyle($cellRange)->applyFromArray($styleArray);
                // $event->sheet->getParent()->getDefaultStyle()->applyFromArray($default_font_style);
                $event->sheet->getStyle('A1:G1')->applyFromArray($default_font_style);
                $event->sheet->getStyle('A2:G2')->applyFromArray($header_font);
            },
        ];
    }

    public function headings(): array
    {
        return [
            [
                'Project',
                'Unit',
                'Client Name',
                'Sales Person',
                'Project Value',
                'Total Amount Received',
                'Balance Amount',










            ],
        ];
    }
}
