<?php

namespace App\Exports;

use App\WhatsAppContact;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class WhatsappExport implements  FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
    use Exportable;

    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
  
    
    }

    public function query()
    {

     
        $project = $this->request->project_id ?? '';
        $userId = $this->request->user_id ?? '';
        $fromDate = '';
        $toDate = '';
    
        if ($this->request->receipt_from_date) {

            $fromDate = Carbon::parse($this->request->receipt_from_date)->startOfDay()->format('Y-m-d H:i:s');
           
        }

        if ($this->request->to_date) {
            $toDate = Carbon::parse($this->request->to_date)->endOfDay()->format('Y-m-d H:i:s');
        }

        $rows = WhatsAppContact::query()
        ->with('getUser', 'getProject')->where('duplicate_entry', 'no')
           
            ->when($project, function ($q, $project) {
                return $q->where('preferred_project', $project);
            })
            ->when($fromDate, function ($q, $fromDate) {
                return $q->whereDate('lead_date', '>=', $fromDate);
            })
            ->when($toDate, function ($q, $toDate) {
                return $q->whereDate('lead_date', '<=', $toDate);
            })->when($userId , function($q,$userId){
                return $q->where('attended_by', $userId);
            });

            return $rows->orderBy('lead_date', 'desc');

    }

    public function headings(): array
    {
        $set1 = [
            'phone_no',
            'cust_name||TEXT',
            'cust_email||TEXT',
            'new_city||TEXT',
            'first_name',
            'last_name',
            'email',
            'first_name',
            'city',
            'state',
            'country',

         
         
          
        ];
   
      
        return  $set1;
    }

    public function map($lead): array
    {
  
        
        $set1 = [
            $lead->mobile,
            $lead->enquirer_name,
            'test@gmail.com',
            'Calicut', 
            $lead->enquirer_name,
            $lead->enquirer_name,
            'test@gmail.com',
            $lead->enquirer_name,
            'Calicut',
            'Kerala',
            'india'

    
         
        ];
      
       
        return  $set1;
    }

    public function fields(): array
    {
        $set1 = [
            'mobile',
            'enquirer_name',
            'email',
            'city',
            'enquirer_name',
            'enquirer_name',
            'email',
            'enquirer_name',
            'city',
            'state',
            'country'
          
          
        ];
       
        
        return  $set1;
    }
}